/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.script;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.indexedscripts.get.GetIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.get.GetIndexedScriptResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestGetIndexedScriptAction
extends BaseRestHandler {
    @Inject
    public RestGetIndexedScriptAction(Settings settings, RestController controller, Client client) {
        this(settings, controller, true, client);
    }

    protected RestGetIndexedScriptAction(Settings settings, RestController controller, boolean registerDefaultHandlers, Client client) {
        super(settings, controller, client);
        if (registerDefaultHandlers) {
            controller.registerHandler(RestRequest.Method.GET, "/_scripts/{lang}/{id}", this);
        }
    }

    protected XContentBuilderString getScriptFieldName() {
        return Fields.SCRIPT;
    }

    protected String getScriptLang(RestRequest request) {
        return request.param("lang");
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        GetIndexedScriptRequest getRequest = new GetIndexedScriptRequest(this.getScriptLang(request), request.param("id"));
        getRequest.version(request.paramAsLong("version", getRequest.version()));
        getRequest.versionType(VersionType.fromString(request.param("version_type"), getRequest.versionType()));
        client.getIndexedScript(getRequest, (ActionListener<GetIndexedScriptResponse>)new RestBuilderListener<GetIndexedScriptResponse>(channel){

            @Override
            public RestResponse buildResponse(GetIndexedScriptResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field(Fields.LANG, response.getScriptLang());
                builder.field(Fields._ID, response.getId());
                builder.field(Fields.FOUND, response.isExists());
                RestStatus status = RestStatus.NOT_FOUND;
                if (response.isExists()) {
                    builder.field(Fields._VERSION, response.getVersion());
                    builder.field(RestGetIndexedScriptAction.this.getScriptFieldName(), response.getScript());
                    status = RestStatus.OK;
                }
                builder.endObject();
                return new BytesRestResponse(status, builder);
            }
        });
    }

    private static final class Fields {
        private static final XContentBuilderString SCRIPT = new XContentBuilderString("script");
        private static final XContentBuilderString LANG = new XContentBuilderString("lang");
        private static final XContentBuilderString _ID = new XContentBuilderString("_id");
        private static final XContentBuilderString _VERSION = new XContentBuilderString("_version");
        private static final XContentBuilderString FOUND = new XContentBuilderString("found");

        private Fields() {
        }
    }
}

