// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDLMM_DOCKITEM_H
#define _GDLMM_DOCKITEM_H

#include <gdlmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (c) 2009  Fabien Parent <parent.f@gmail.com>
 *
 * This file is part of gdlmm.
 *
 * gdlmm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2.1 of the License,
 * or (at your option) any later version.
 *
 * gdlmm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <gtkmm.h>
#include "dockobject.h"

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdlDockItem GdlDockItem;
typedef struct _GdlDockItemClass GdlDockItemClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdl
{ class DockItem_Class; } // namespace Gdl
namespace Gdl
{


/** @addtogroup gdlmmEnums gdlmm Enums and Flags */

/**
 * @ingroup gdlmmEnums
 * @par Bitwise operators:
 * <tt>%DockItemBehavior operator|(DockItemBehavior, DockItemBehavior)</tt><br>
 * <tt>%DockItemBehavior operator&(DockItemBehavior, DockItemBehavior)</tt><br>
 * <tt>%DockItemBehavior operator^(DockItemBehavior, DockItemBehavior)</tt><br>
 * <tt>%DockItemBehavior operator~(DockItemBehavior)</tt><br>
 * <tt>%DockItemBehavior& operator|=(DockItemBehavior&, DockItemBehavior)</tt><br>
 * <tt>%DockItemBehavior& operator&=(DockItemBehavior&, DockItemBehavior)</tt><br>
 * <tt>%DockItemBehavior& operator^=(DockItemBehavior&, DockItemBehavior)</tt><br>
 */
enum DockItemBehavior
{
  DOCK_ITEM_BEH_NORMAL = 0,
  DOCK_ITEM_BEH_NEVER_FLOATING = 1 << 0,
  DOCK_ITEM_BEH_NEVER_VERTICAL = 1 << 1,
  DOCK_ITEM_BEH_NEVER_HORIZONTAL = 1 << 2,
  DOCK_ITEM_BEH_LOCKED = 1 << 3,
  DOCK_ITEM_BEH_CANT_DOCK_TOP = 1 << 4,
  DOCK_ITEM_BEH_CANT_DOCK_BOTTOM = 1 << 5,
  DOCK_ITEM_BEH_CANT_DOCK_LEFT = 1 << 6,
  DOCK_ITEM_BEH_CANT_DOCK_RIGHT = 1 << 7,
  DOCK_ITEM_BEH_CANT_DOCK_CENTER = 1 << 8,
  DOCK_ITEM_BEH_CANT_CLOSE = 1 << 9,
  DOCK_ITEM_BEH_CANT_ICONIFY = 1 << 10,
  DOCK_ITEM_BEH_NO_GRIP = 1 << 11
};

/** @ingroup gdlmmEnums */
inline DockItemBehavior operator|(DockItemBehavior lhs, DockItemBehavior rhs)
  { return static_cast<DockItemBehavior>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdlmmEnums */
inline DockItemBehavior operator&(DockItemBehavior lhs, DockItemBehavior rhs)
  { return static_cast<DockItemBehavior>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdlmmEnums */
inline DockItemBehavior operator^(DockItemBehavior lhs, DockItemBehavior rhs)
  { return static_cast<DockItemBehavior>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdlmmEnums */
inline DockItemBehavior operator~(DockItemBehavior flags)
  { return static_cast<DockItemBehavior>(~static_cast<unsigned>(flags)); }

/** @ingroup gdlmmEnums */
inline DockItemBehavior& operator|=(DockItemBehavior& lhs, DockItemBehavior rhs)
  { return (lhs = static_cast<DockItemBehavior>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdlmmEnums */
inline DockItemBehavior& operator&=(DockItemBehavior& lhs, DockItemBehavior rhs)
  { return (lhs = static_cast<DockItemBehavior>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdlmmEnums */
inline DockItemBehavior& operator^=(DockItemBehavior& lhs, DockItemBehavior rhs)
  { return (lhs = static_cast<DockItemBehavior>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdl


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdl::DockItemBehavior> : public Glib::Value_Flags<Gdl::DockItemBehavior>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdl
{

/**
 * @ingroup gdlmmEnums
 */
enum DockItemFlags
{
  DOCK_IN_DRAG = 1 << 8,
  DOCK_IN_PREDRAG = 1 << 9,
  DOCK_ICONIFIED = 1 << 10,
  DOCK_USER_ACTION = 1 << 11
};

} // namespace Gdl


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdl::DockItemFlags> : public Glib::Value_Enum<Gdl::DockItemFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdl
{


class DockItem : public DockObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DockItem CppObjectType;
  typedef DockItem_Class CppClassType;
  typedef GdlDockItem BaseObjectType;
  typedef GdlDockItemClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~DockItem();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class DockItem_Class;
  static CppClassType dockitem_class_;

  // noncopyable
  DockItem(const DockItem&);
  DockItem& operator=(const DockItem&);

protected:
  explicit DockItem(const Glib::ConstructParams& construct_params);
  explicit DockItem(GdlDockItem* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GdlDockItem*       gobj()       { return reinterpret_cast<GdlDockItem*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GdlDockItem* gobj() const { return reinterpret_cast<GdlDockItem*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_dock_drag_begin().
  virtual void on_dock_drag_begin();
  /// This is a default handler for the signal signal_dock_drag_end().
  virtual void on_dock_drag_end(bool cancel);
  /// This is a default handler for the signal signal_dock_drag_motion().
  virtual void on_dock_drag_motion(const Glib::RefPtr<Gdk::Device>& device, int x, int y);


private:


public:
  DockItem(const Glib::ustring& name, const Glib::ustring& long_name, DockItemBehavior behavior = static_cast<DockItemBehavior>(DOCK_ITEM_BEH_NORMAL));
  
  DockItem(const Glib::ustring& name, const Glib::ustring& long_name, const Gtk::StockID& stock_id, DockItemBehavior behavior = static_cast<DockItemBehavior>(DOCK_ITEM_BEH_NORMAL));
  
  
  void dock_to(DockItem& target, DockPlacement position =  static_cast<DockPlacement>(DOCK_NONE), int docking_param =  -1);
  
  void dock_floating(int docking_param = -1);
  
  
  void set_orientation(Gtk::Orientation orientation);
  
  
  Gtk::Widget* get_tablabel() const;
  
  
  void set_tablabel(Gtk::Widget& tablabel);

  
  Gtk::Widget* get_grip() const;
  
  
  void hide_grip();
  
  
  void show_grip();
  
  
  void notify_selected();
  
  
  void bind(Gtk::Widget& dock);
  
  
  void unbind();
  
  
  void hide_item();
  
  
  void iconify_item();
  
  
  void show_item();
  
  
  void lock();
  
  
  void unlock();
  
  
  void set_default_position(DockObject& reference);
  
  
  void preferred_size(Gtk::Requisition& req);
  
  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** General behavior for the dock item (i.e. whether it can float, if it's locked, etc.).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< DockItemBehavior > property_behavior() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** General behavior for the dock item (i.e. whether it can float, if it's locked, etc.).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< DockItemBehavior > property_behavior() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If set, the dock item cannot be dragged around and it doesn't show a grip.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_locked() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If set, the dock item cannot be dragged around and it doesn't show a grip.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_locked() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Orientation of the docking item.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Gtk::Orientation > property_orientation() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Orientation of the docking item.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gtk::Orientation > property_orientation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Preferred height for the dock item.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< int > property_preferred_height() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Preferred height for the dock item.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_preferred_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Preferred width for the dock item.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< int > property_preferred_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Preferred width for the dock item.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_preferred_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If set, the dock item can be resized when docked in a GtkPanel widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_resize() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If set, the dock item can be resized when docked in a GtkPanel widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_resize() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  //gtkmmproc error: long-name : property defs lookup failed.
  
  
/**
   * @par Slot Prototype:
   * <tt>void on_my_%dock_drag_begin()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_dock_drag_begin();

  
/**
   * @par Slot Prototype:
   * <tt>void on_my_%dock_drag_end(bool cancel)</tt>
   *
   */

  Glib::SignalProxy1< void,bool > signal_dock_drag_end();

  
/**
   * @par Slot Prototype:
   * <tt>void on_my_%dock_drag_motion(const Glib::RefPtr<Gdk::Device>& device, int x, int y)</tt>
   *
   */

  Glib::SignalProxy3< void,const Glib::RefPtr<Gdk::Device>&,int,int > signal_dock_drag_motion();

  
/**
   * @par Slot Prototype:
   * <tt>void on_my_%selected()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_selected();


};

} // namespace Gdl


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdl::DockItem
   */
  Gdl::DockItem* wrap(GdlDockItem* object, bool take_copy = false);
} //namespace Glib


#endif /* _GDLMM_DOCKITEM_H */

