/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.api.logging.LogLevel;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.DefaultBuildRequestContext;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.composite.CompositeBuildActionParameters;
import org.gradle.internal.composite.CompositeBuildActionRunner;
import org.gradle.internal.composite.CompositeBuildController;
import org.gradle.internal.composite.CompositeParameters;
import org.gradle.internal.composite.GradleParticipantBuild;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.BuildSessionScopeServices;
import org.gradle.launcher.daemon.configuration.DaemonUsage;
import org.gradle.launcher.exec.DefaultBuildActionParameters;
import org.gradle.launcher.exec.InProcessBuildActionExecuter;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.connection.DefaultBuildIdentifier;
import org.gradle.tooling.internal.connection.DefaultProjectIdentifier;
import org.gradle.tooling.internal.consumer.connection.InternalBuildActionAdapter;
import org.gradle.tooling.internal.provider.BuildActionResult;
import org.gradle.tooling.internal.provider.BuildModelAction;
import org.gradle.tooling.internal.provider.ClientProvidedBuildAction;
import org.gradle.tooling.internal.provider.PayloadSerializer;
import org.gradle.tooling.internal.provider.SerializedPayload;
import org.gradle.tooling.internal.provider.runner.ClientProvidedBuildActionRunner;
import org.gradle.tooling.internal.provider.runner.SubscribableBuildActionRunner;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.BasicGradleProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeBuildModelActionRunner
implements CompositeBuildActionRunner {
    public void run(org.gradle.internal.invocation.BuildAction action, BuildRequestContext requestContext, CompositeBuildActionParameters actionParameters, CompositeBuildController buildController) {
        if (!(action instanceof BuildModelAction)) {
            return;
        }
        Class<?> modelType = this.resolveModelType((BuildModelAction)action);
        HashMap<Object, Object> results = null;
        if (modelType != Void.class) {
            results = new HashMap<Object, Object>();
            results.putAll(this.fetchCompositeModelsInProcess((BuildModelAction)action, modelType, requestContext, actionParameters.getCompositeParameters().getBuilds(), buildController.getBuildScopeServices()));
        } else {
            if (!((BuildModelAction)action).isRunTasks()) {
                throw new IllegalStateException("No tasks defined.");
            }
            this.executeTasksInProcess(action.getStartParameter(), actionParameters, requestContext, buildController.getBuildScopeServices());
        }
        PayloadSerializer payloadSerializer = (PayloadSerializer)buildController.getBuildScopeServices().get(PayloadSerializer.class);
        buildController.setResult((Object)new BuildActionResult(payloadSerializer.serialize(results), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTasksInProcess(StartParameter parentStartParam, CompositeBuildActionParameters actionParameters, BuildRequestContext buildRequestContext, ServiceRegistry sharedServices) {
        CompositeParameters compositeParameters = actionParameters.getCompositeParameters();
        List participantBuilds = compositeParameters.getBuilds();
        GradleLauncherFactory launcherFactory = (GradleLauncherFactory)sharedServices.get(GradleLauncherFactory.class);
        boolean buildFound = false;
        for (GradleParticipantBuild participant : participantBuilds) {
            buildFound = true;
            if (buildRequestContext.getCancellationToken().isCancellationRequested()) break;
            StartParameter startParameter = parentStartParam.newInstance();
            startParameter.setProjectDir(participant.getProjectDir());
            startParameter.setSearchUpwards(false);
            DefaultBuildRequestContext requestContext = new DefaultBuildRequestContext((BuildRequestMetaData)new DefaultBuildRequestMetaData((BuildClientMetaData)new GradleLauncherMetaData(), System.currentTimeMillis()), buildRequestContext.getCancellationToken(), buildRequestContext.getEventConsumer(), buildRequestContext.getOutputListener(), buildRequestContext.getErrorListener());
            GradleLauncher launcher = launcherFactory.newInstance(startParameter, (BuildRequestContext)requestContext, sharedServices);
            try {
                launcher.run();
            }
            finally {
                launcher.stop();
            }
        }
        if (!buildFound) {
            throw new IllegalStateException("Build not part of composite");
        }
    }

    private Class<?> resolveModelType(BuildModelAction action) {
        String requestedModelName = action.getModelName();
        try {
            return (Class)Cast.uncheckedCast(this.getClass().getClassLoader().loadClass(requestedModelName));
        }
        catch (ClassNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private <T> Map<Object, Object> fetchCompositeModelsInProcess(BuildModelAction modelAction, Class<T> modelType, BuildRequestContext buildRequestContext, List<GradleParticipantBuild> participantBuilds, ServiceRegistry sharedServices) {
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        PayloadSerializer payloadSerializer = (PayloadSerializer)sharedServices.get(PayloadSerializer.class);
        GradleLauncherFactory gradleLauncherFactory = (GradleLauncherFactory)sharedServices.get(GradleLauncherFactory.class);
        SubscribableBuildActionRunner runner = new SubscribableBuildActionRunner(new ClientProvidedBuildActionRunner());
        InProcessBuildActionExecuter buildActionExecuter = new InProcessBuildActionExecuter(gradleLauncherFactory, (BuildActionRunner)runner);
        DefaultBuildRequestContext requestContext = new DefaultBuildRequestContext((BuildRequestMetaData)new DefaultBuildRequestMetaData(System.currentTimeMillis()), buildRequestContext.getCancellationToken(), buildRequestContext.getEventConsumer(), buildRequestContext.getOutputListener(), buildRequestContext.getErrorListener());
        ProtocolToModelAdapter protocolToModelAdapter = new ProtocolToModelAdapter();
        FetchPerProjectModelAction fetchPerProjectModelAction = new FetchPerProjectModelAction(modelType.getName());
        InternalBuildActionAdapter internalBuildAction = new InternalBuildActionAdapter((BuildAction)fetchPerProjectModelAction, protocolToModelAdapter);
        SerializedPayload serializedAction = payloadSerializer.serialize((Object)internalBuildAction);
        for (GradleParticipantBuild participant : participantBuilds) {
            DefaultBuildActionParameters actionParameters = new DefaultBuildActionParameters(Collections.EMPTY_MAP, Collections.emptyMap(), participant.getProjectDir(), LogLevel.INFO, DaemonUsage.EXPLICITLY_DISABLED, false, true, ClassPath.EMPTY);
            StartParameter startParameter = modelAction.getStartParameter().newInstance();
            startParameter.setProjectDir(participant.getProjectDir());
            BuildSessionScopeServices buildScopedServices = new BuildSessionScopeServices(sharedServices, startParameter, ClassPath.EMPTY);
            ClientProvidedBuildAction mappedAction = new ClientProvidedBuildAction(startParameter, serializedAction, modelAction.getClientSubscriptions());
            try {
                BuildActionResult result = (BuildActionResult)buildActionExecuter.execute((org.gradle.internal.invocation.BuildAction)mappedAction, (BuildRequestContext)requestContext, (Object)actionParameters, (ServiceRegistry)buildScopedServices);
                if (result.result != null) {
                    Map values = (Map)Cast.uncheckedCast((Object)payloadSerializer.deserialize(result.result));
                    for (Map.Entry e : values.entrySet()) {
                        InternalProjectIdentity internalProjectIdentity = (InternalProjectIdentity)e.getKey();
                        results.put(this.convertToProjectIdentity(internalProjectIdentity), e.getValue());
                    }
                    continue;
                }
                Throwable failure = (Throwable)payloadSerializer.deserialize(result.failure);
                File rootDir = participant.getProjectDir();
                DefaultBuildIdentifier buildIdentifier = new DefaultBuildIdentifier(rootDir);
                results.put(new DefaultProjectIdentifier((BuildIdentifier)buildIdentifier, ":"), failure);
            }
            catch (Exception e) {
                File rootDir = participant.getProjectDir();
                DefaultBuildIdentifier buildIdentifier = new DefaultBuildIdentifier(rootDir);
                results.put(new DefaultProjectIdentifier((BuildIdentifier)buildIdentifier, ":"), e);
            }
        }
        return results;
    }

    private DefaultProjectIdentifier convertToProjectIdentity(InternalProjectIdentity internalProjectIdentity) {
        return new DefaultProjectIdentifier((BuildIdentifier)new DefaultBuildIdentifier(internalProjectIdentity.rootDir), internalProjectIdentity.projectPath);
    }

    private static final class InternalProjectIdentity
    implements Serializable {
        private final File rootDir;
        private final String projectPath;

        private InternalProjectIdentity(File rootDir, String projectPath) {
            this.rootDir = rootDir;
            this.projectPath = projectPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FetchPerProjectModelAction
    implements BuildAction<Map<Object, Object>> {
        private final String modelTypeName;

        private FetchPerProjectModelAction(String modelTypeName) {
            this.modelTypeName = modelTypeName;
        }

        public Map<Object, Object> execute(BuildController controller) {
            Class<?> modelType;
            try {
                modelType = Class.forName(this.modelTypeName);
            }
            catch (ClassNotFoundException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            HashMap<Object, Object> results = new HashMap<Object, Object>();
            this.fetchResults(modelType, results, controller, controller.getBuildModel().getRootProject(), controller.getBuildModel().getRootProject());
            return results;
        }

        private void fetchResults(Class<?> modelType, Map<Object, Object> results, BuildController controller, BasicGradleProject project, BasicGradleProject rootProject) {
            File rootDir = rootProject.getProjectDirectory();
            results.put(new InternalProjectIdentity(rootDir, project.getPath()), controller.getModel((Model)project, modelType));
            for (BasicGradleProject child : project.getChildren()) {
                this.fetchResults(modelType, results, controller, child, rootProject);
            }
        }
    }
}

