/*! grafana - v3.0.4 - 2016-06-01
 * Copyright (c) 2016 Torkel Ödegaard; Licensed Apache-2.0 */

define(["test/mocks/dashboard-mock","test/specs/helpers","lodash","moment","app/core/services/timer","app/features/dashboard/timeSrv"],function(a,b,c,d){"use strict";describe("timeSrv",function(){var c,e=new b.ServiceTestContext;beforeEach(module("grafana.core")),beforeEach(module("grafana.services")),beforeEach(e.providePhase(["$routeParams"])),beforeEach(e.createService("timeSrv")),beforeEach(function(){c=a.create(),e.service.init(c)}),describe("timeRange",function(){it("should return unparsed when parse is false",function(){e.service.setTime({from:"now",to:"now-1h"});var a=e.service.timeRange(!1);expect(a.from).to.be("now"),expect(a.to).to.be("now-1h")}),it("should return parsed when parse is true",function(){e.service.setTime({from:"now",to:"now-1h"});var a=e.service.timeRange(!0);expect(d.isMoment(a.from)).to.be(!0),expect(d.isMoment(a.to)).to.be(!0)})}),describe("init time from url",function(){it("should handle relative times",function(){e.$routeParams.from="now-2d",e.$routeParams.to="now",e.service.init(c);var a=e.service.timeRange(!1);expect(a.from).to.be("now-2d"),expect(a.to).to.be("now")}),it("should handle formated dates",function(){e.$routeParams.from="20140410T052010",e.$routeParams.to="20140520T031022",e.service.init(c);var a=e.service.timeRange(!0);expect(a.from.valueOf()).to.equal(new Date("2014-04-10T05:20:10Z").getTime()),expect(a.to.valueOf()).to.equal(new Date("2014-05-20T03:10:22Z").getTime())}),it("should handle formated dates without time",function(){e.$routeParams.from="20140410",e.$routeParams.to="20140520",e.service.init(c);var a=e.service.timeRange(!0);expect(a.from.valueOf()).to.equal(new Date("2014-04-10T00:00:00Z").getTime()),expect(a.to.valueOf()).to.equal(new Date("2014-05-20T00:00:00Z").getTime())}),it("should handle epochs",function(){e.$routeParams.from="1410337646373",e.$routeParams.to="1410337665699",e.service.init(c);var a=e.service.timeRange(!0);expect(a.from.valueOf()).to.equal(1410337646373),expect(a.to.valueOf()).to.equal(1410337665699)}),it("should handle bad dates",function(){e.$routeParams.from="20151126T00010%3C%2Fp%3E%3Cspan%20class",e.$routeParams.to="now",c.time.from="now-6h",e.service.init(c),expect(e.service.time.from).to.equal("now-6h"),expect(e.service.time.to).to.equal("now")})}),describe("setTime",function(){it("should return disable refresh if refresh is disabled for any range",function(){c.refresh=!1,e.service.setTime({from:"2011-01-01",to:"2015-01-01"}),expect(c.refresh).to.be(!1)}),it("should restore refresh for absolute time range",function(){c.refresh="30s",e.service.setTime({from:"2011-01-01",to:"2015-01-01"}),expect(c.refresh).to.be("30s")}),it("should restore refresh after relative time range is set",function(){c.refresh="10s",e.service.setTime({from:d([2011,1,1]),to:d([2015,1,1])}),expect(c.refresh).to.be(!1),e.service.setTime({from:"2011-01-01",to:"now"}),expect(c.refresh).to.be("10s")}),it("should keep refresh after relative time range is changed and now delay exists",function(){c.refresh="10s",e.service.setTime({from:"now-1h",to:"now-10s"}),expect(c.refresh).to.be("10s")})})})});