#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: esqueleto
version: 2.4.3
id: esqueleto-2.4.3-a13a95ac309066dbfab8f0c73b113d4e
key: esque_AX85RRRNKFfAPeEFCLwGFn
license: BSD3
copyright: (c) 2012-2015 Felipe Almeida Lessa
maintainer: felipe.lessa@gmail.com
homepage: https://github.com/prowdsponsor/esqueleto
synopsis: Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries
    that works with unmodified @persistent@ SQL backends.  Its
    language closely resembles SQL, so you don'\''t have to learn
    new concepts, just new syntax, and it'\''s fairly easy to
    predict the generated SQL and optimize it for your backend.
    Most kinds of errors committed when writing SQL are caught as
    compile-time errors---although it is possible to write
    type-checked @esqueleto@ queries that fail at runtime.
    .
    @persistent@ is a library for type-safe data serialization.  It
    has many kinds of backends, such as SQL backends
    (@persistent-mysql@, @persistent-postgresql@,
    @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@).
    While @persistent@ is a nice library for storing and retrieving
    records, including with filters, it does not try to support
    some of the features that are specific to SQL backends.  In
    particular, @esqueleto@ is the recommended library for
    type-safe @JOIN@s on @persistent@ SQL backends.  (The
    alternative is using raw SQL, but that'\''s error prone and does
    not offer any composability.)
    .
    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported.
    Not all SQL features are available, but most of them can be easily added
    (especially functions), so please open an issue or send a pull request if
    you need anything that is not covered by @esqueleto@ on
    <https://github.com/prowdsponsor/esqueleto/>.
    .
    The name of this library means \"skeleton\" in Portuguese and
    contains all three SQL letters in the correct order =).  It was
    inspired by Scala'\''s Squeryl but created from scratch.
category: Database
author: Felipe Lessa
exposed: True
exposed-modules:
    Database.Esqueleto Database.Esqueleto.PostgreSQL
    Database.Esqueleto.Internal.Language
    Database.Esqueleto.Internal.Sql
hidden-modules: Database.Esqueleto.Internal.PersistentImport
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/esqueleto-2.4.3
library-dirs: /usr/lib/ghc-7.10.3/site-local/esqueleto-2.4.3
data-dir: /usr/share/arm-linux-ghc-7.10.3/esqueleto-2.4.3
hs-libraries: HSesqueleto-2.4.3-AX85RRRNKFfAPeEFCLwGFn
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    blaze-html-0.8.1.1-196db2ddcb827bc04473411dd00dd5eb
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    conduit-1.2.6.6-d359386885a03b60281b91c4e140d8f4
    monad-logger-0.3.18-1374b457a8b7165408364c0bd477c532
    persistent-2.2.4.1-53b32e0b8931dd68fbb356ac374c65f3
    resourcet-1.1.7.4-51f149abafdcf0369a30d929df00de54
    tagged-0.8.4-af2e23230031c45949e0062e776a8f1f
    text-1.2.2.1-18afbfeccf88d72c4b6e468c86d2b77d
    transformers-0.4.2.0-252429dba576bc247c1932da496e0a3f
    unordered-containers-0.2.7.0-d91279dcd5fa13d7f88095dc08e2fda6
haddock-interfaces: /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html: /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
