#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: generic-deriving
version: 1.10.4.1
id: generic-deriving-1.10.4.1-fa7ac74efc244fd2c65cbc397a8ee9d1
key: gener_4muyIVxZ7QRKCGjZWaE4oP
license: BSD3
copyright: 2011-2013 Universiteit Utrecht, University of Oxford
maintainer: generics@haskell.org
stability: experimental
homepage: https://github.com/dreixel/generic-deriving
synopsis: Generic programming library for generalised deriving.
description:
    This package provides functionality for generalising the deriving mechanism
    in Haskell to arbitrary classes. It was first described in the paper:
    .
    *  /A generic deriving mechanism for Haskell/.
    Jose Pedro Magalhaes, Atze Dijkstra, Johan Jeuring, and Andres Loeh.
    Haskell'\''10.
    .
    The current implementation integrates with the new GHC Generics. See
    <http://www.haskell.org/haskellwiki/GHC.Generics> for more information.
    Template Haskell code is provided for supporting GHC before version 7.2.
category: Generics
author: José Pedro Magalhães
exposed: True
exposed-modules:
    Generics.Deriving Generics.Deriving.Base
    Generics.Deriving.Instances Generics.Deriving.Copoint
    Generics.Deriving.ConNames Generics.Deriving.Enum
    Generics.Deriving.Eq Generics.Deriving.Foldable
    Generics.Deriving.Functor Generics.Deriving.Monoid
    Generics.Deriving.Semigroup Generics.Deriving.Show
    Generics.Deriving.Traversable Generics.Deriving.Uniplate
    Generics.Deriving.TH
hidden-modules: Generics.Deriving.Base.Internal
                Generics.Deriving.TH.Internal Paths_generic_deriving
                Generics.Deriving.TH.Pre711
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/generic-deriving-1.10.4.1
library-dirs: /usr/lib/ghc-7.10.3/site-local/generic-deriving-1.10.4.1
data-dir: /usr/share/arm-linux-ghc-7.10.3/generic-deriving-1.10.4.1
hs-libraries: HSgeneric-deriving-1.10.4.1-4muyIVxZ7QRKCGjZWaE4oP
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    ghc-prim-0.4.0.0-bf246eb9fdda7435f0c147a313ce59fb
    template-haskell-2.10.0.0-4b92ab565139fd81021b60a162b59eb8
haddock-interfaces: /usr/share/doc/haskell-generic-deriving/html/generic-deriving.haddock
haddock-html: /usr/share/doc/haskell-generic-deriving/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
