#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: semigroupoids
version: 5.0.1
id: semigroupoids-5.0.1-8eb2d2c8f0f0def85cbb7c35538a003a
key: semig_IFBU77hSbUD7lvpAJeOqOt
license: BSD3
copyright: Copyright (C) 2011-2015 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/semigroupoids
synopsis: Semigroupoids: Category sans id
description:
    Provides a wide array of (semi)groupoids and operations for working with them.
    .
    A '\''Semigroupoid'\'' is a '\''Category'\'' without the requirement of identity arrows for every object in the category.
    .
    A '\''Category'\'' is any '\''Semigroupoid'\'' for which the Yoneda lemma holds.
    .
    When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
    not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
    in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.
    .
    Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.
    .
    Ideally the following relationships would hold:
    .
    > Foldable ----> Traversable <--- Functor ------> Alt ---------> Plus           Semigroupoid
    >      |               |            |                              |                  |
    >      v               v            v                              v                  v
    > Foldable1 ---> Traversable1     Apply --------> Applicative -> Alternative      Category
    >                                   |               |              |                  |
    >                                   v               v              v                  v
    >                                 Bind ---------> Monad -------> MonadPlus          Arrow
    >
    .
    Apply, Bind, and Extend (not shown) give rise the Static, Kleisli and Cokleisli semigroupoids respectively.
    .
    This lets us remove many of the restrictions from various monad transformers
    as in many cases the binding operation or @\<*\>@ operation does not require them.
    .
    Finally, to work with these weaker structures it is beneficial to have containers
    that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
    and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.
category: Control, Comonads
author: Edward A. Kmett
exposed: True
exposed-modules:
    Data.Bifunctor.Apply Data.Functor.Alt Data.Functor.Apply
    Data.Functor.Bind Data.Functor.Bind.Class Data.Functor.Bind.Trans
    Data.Functor.Extend Data.Functor.Plus Data.Groupoid
    Data.Isomorphism Data.Semigroup.Bifoldable
    Data.Semigroup.Bitraversable Data.Semigroup.Foldable
    Data.Semigroup.Foldable.Class Data.Semigroup.Traversable
    Data.Semigroup.Traversable.Class Data.Semigroupoid
    Data.Semigroupoid.Dual Data.Semigroupoid.Ob
    Data.Semigroupoid.Static Data.Traversable.Instances
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/semigroupoids-5.0.1
library-dirs: /usr/lib/ghc-7.10.3/site-local/semigroupoids-5.0.1
data-dir: /usr/share/arm-linux-ghc-7.10.3/semigroupoids-5.0.1
hs-libraries: HSsemigroupoids-5.0.1-IFBU77hSbUD7lvpAJeOqOt
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    base-orphans-0.5.4-e40139ef3f9e9946a3f68f9fef66a420
    bifunctors-5.3-bc094c1e88d075fab4936b454b930127
    comonad-5-9b3bac8b2740903020c84a0c2eebf7b2
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    contravariant-1.4-1b3716257293d15c38698a7852cba3ac
    distributive-0.5.0.2-77d85d8c453ea57cf04087f9320d2bf7
    semigroups-0.18.1-1d5ad88275231b75d5bd2afbb0ecbbe4
    tagged-0.8.4-af2e23230031c45949e0062e776a8f1f
    transformers-0.4.2.0-252429dba576bc247c1932da496e0a3f
    transformers-compat-0.5.1.4-b5340b5b89d4b4066d5de0d53e173907
haddock-interfaces: /usr/share/doc/haskell-semigroupoids/html/semigroupoids.haddock
haddock-html: /usr/share/doc/haskell-semigroupoids/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
