#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: texmath
version: 0.8.6.2
id: texmath-0.8.6.2-a3b68b8ea0b0cf165235dc5ba9c78e82
key: texma_3l5XwFMnxMxIUngz1eiEhS
license: GPL
maintainer: jgm@berkeley.edu
stability: Experimental
homepage: http://github.com/jgm/texmath
synopsis: Conversion between formats used to represent mathematics.
description:
    The texmath library provides functions to read and
    write TeX math, presentation MathML, and OMML (Office
    Math Markup Language, used in Microsoft Office).
    Support is also included for converting math formats
    to pandoc'\''s native format (allowing conversion, via
    pandoc, to a variety of different markup formats).
    The TeX reader supports basic LaTeX and AMS extensions,
    and it can parse and apply LaTeX macros.
    (See <http://johnmacfarlane.net/texmath here> for a live
    demo of bidirectional conversion between LaTeX
    and MathML.)
    .
    The package also includes several utility modules which
    may be useful for anyone looking to manipulate either
    TeX math or MathML.  For example, a copy of the MathML
    operator dictionary is included.
    .
    Use the @executable@ flag to install a standalone
    executable, @texmath@, that by default reads a LaTeX
    formula from @stdin@ and writes MathML to @stdout@.
    With flags all the functionality exposed by
    '\''Text.TeXMath'\'' can be accessed through this executable.
    (Use the @--help@ flag for a description of all
    functionality)
    .
    The @texmath@ executable can also be used as a CGI
    script, when renamed as @texmath-cgi@.
    It will expect query parameters for @from@, @to@,
    @input@, and optionally @inline@, and return a JSON
    object with either @error@ and a message or
    @success@ and the converted result.
category: Text
author: John MacFarlane, Matthew Pickering
exposed: True
exposed-modules:
    Text.TeXMath Text.TeXMath.Types Text.TeXMath.Readers.TeX
    Text.TeXMath.Readers.TeX.Macros Text.TeXMath.Readers.MathML
    Text.TeXMath.Readers.MathML.MMLDict
    Text.TeXMath.Readers.MathML.EntityMap Text.TeXMath.Readers.OMML
    Text.TeXMath.Writers.MathML Text.TeXMath.Writers.OMML
    Text.TeXMath.Writers.Pandoc Text.TeXMath.Writers.TeX
    Text.TeXMath.Unicode.ToUnicode Text.TeXMath.Unicode.ToTeX
    Text.TeXMath.Unicode.ToASCII
hidden-modules: Text.TeXMath.Compat Text.TeXMath.Shared
                Text.TeXMath.TeX Paths_texmath
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/texmath-0.8.6.2
library-dirs: /usr/lib/ghc-7.10.3/site-local/texmath-0.8.6.2
data-dir: /usr/share/arm-linux-ghc-7.10.3/texmath-0.8.6.2
hs-libraries: HStexmath-0.8.6.2-3l5XwFMnxMxIUngz1eiEhS
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    mtl-2.2.1-c516313407bc17046965067cb7cbb6a0
    pandoc-types-1.16.1-30bcf2ba2a8f2fe5e0ad6c109c33aa1e
    parsec-3.1.11-2df9dc070a05b018377712731c5dde62
    syb-0.6-56a5944f55f7a9d47e7b770375c0e1ae
    xml-1.3.14-6291d85df68e094bfca87f33fea8b24c
haddock-interfaces: /usr/share/doc/haskell-texmath/html/texmath.haddock
haddock-html: /usr/share/doc/haskell-texmath/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
