/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ActionParameter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ParameterizedAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSException;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class SearchAction
extends JosmAction
implements ParameterizedAction {
    public static final int DEFAULT_SEARCH_HISTORY_SIZE = 15;
    public static final int MAX_LENGTH_SEARCH_EXPRESSION_DISPLAY = 100;
    private static final String SEARCH_EXPRESSION = "searchExpression";
    private static final LinkedList<SearchSetting> searchHistory = new LinkedList();
    private static volatile SearchSetting lastSearch;

    public static Collection<SearchSetting> getSearchHistory() {
        return searchHistory;
    }

    public static void saveToHistory(SearchSetting searchSetting) {
        if (searchHistory.isEmpty() || !searchSetting.equals(searchHistory.getFirst())) {
            searchHistory.addFirst(new SearchSetting(searchSetting));
        } else if (searchHistory.contains(searchSetting)) {
            searchHistory.remove(searchSetting);
            searchHistory.addFirst(new SearchSetting(searchSetting));
        }
        int n = Main.pref.getInteger("search.history-size", 15);
        while (searchHistory.size() > n) {
            searchHistory.removeLast();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(searchHistory.size());
        for (SearchSetting searchSetting2 : searchHistory) {
            linkedHashSet.add(searchSetting2.writeToString());
        }
        Main.pref.putCollection("search.history", linkedHashSet);
    }

    public static List<String> getSearchExpressionHistory() {
        ArrayList<String> arrayList = new ArrayList<String>(SearchAction.getSearchHistory().size());
        for (SearchSetting searchSetting : SearchAction.getSearchHistory()) {
            arrayList.add(searchSetting.text);
        }
        return arrayList;
    }

    public SearchAction() {
        super(I18n.tr("Search...", new Object[0]), "dialogs/search", I18n.tr("Search for objects.", new Object[0]), Shortcut.registerShortcut("system:find", I18n.tr("Search...", new Object[0]), 70, 5006), true);
        this.putValue("help", HelpUtil.ht("/Action/Search"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        SearchAction.search();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent, Map<String, Object> map) {
        if (map.get(SEARCH_EXPRESSION) == null) {
            this.actionPerformed(actionEvent);
        } else {
            SearchAction.searchWithoutHistory((SearchSetting)map.get(SEARCH_EXPRESSION));
        }
    }

    public static SearchSetting showSearchDialog(SearchSetting searchSetting) {
        if (searchSetting == null) {
            searchSetting = new SearchSetting();
        }
        JLabel jLabel = new JLabel(searchSetting instanceof Filter ? I18n.tr("Filter string:", new Object[0]) : I18n.tr("Search string:", new Object[0]));
        final HistoryComboBox historyComboBox = new HistoryComboBox();
        final String string = I18n.tr("Enter the search expression", new Object[0]);
        historyComboBox.setText(searchSetting.text);
        historyComboBox.setToolTipText(string);
        List<String> list = SearchAction.getSearchExpressionHistory();
        Collections.reverse(list);
        historyComboBox.setPossibleItems(list);
        historyComboBox.setPreferredSize(new Dimension(40, historyComboBox.getPreferredSize().height));
        jLabel.setLabelFor(historyComboBox);
        JRadioButton jRadioButton = new JRadioButton(I18n.tr("replace selection", new Object[0]), searchSetting.mode == SearchMode.replace);
        JRadioButton jRadioButton2 = new JRadioButton(I18n.tr("add to selection", new Object[0]), searchSetting.mode == SearchMode.add);
        JRadioButton jRadioButton3 = new JRadioButton(I18n.tr("remove from selection", new Object[0]), searchSetting.mode == SearchMode.remove);
        JRadioButton jRadioButton4 = new JRadioButton(I18n.tr("find in selection", new Object[0]), searchSetting.mode == SearchMode.in_selection);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        final JCheckBox jCheckBox = new JCheckBox(I18n.tr("case sensitive", new Object[0]), searchSetting.caseSensitive);
        JCheckBox jCheckBox2 = new JCheckBox(I18n.tr("all objects", new Object[0]), searchSetting.allElements);
        jCheckBox2.setToolTipText(I18n.tr("Also include incomplete and deleted objects in search.", new Object[0]));
        JRadioButton jRadioButton5 = new JRadioButton(I18n.tr("standard", new Object[0]), !searchSetting.regexSearch && !searchSetting.mapCSSSearch);
        final JRadioButton jRadioButton6 = new JRadioButton(I18n.tr("regular expression", new Object[0]), searchSetting.regexSearch);
        final JRadioButton jRadioButton7 = new JRadioButton(I18n.tr("MapCSS selector", new Object[0]), searchSetting.mapCSSSearch);
        JCheckBox jCheckBox3 = new JCheckBox(I18n.tr("add toolbar button", new Object[0]), false);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton5);
        buttonGroup2.add(jRadioButton6);
        buttonGroup2.add(jRadioButton7);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, GBC.std().insets(0, 0, 5, 0));
        jPanel.add((Component)historyComboBox, GBC.eol().fill(2));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jRadioButton, GBC.eol());
        jPanel2.add((Component)jRadioButton2, GBC.eol());
        jPanel2.add((Component)jRadioButton3, GBC.eol());
        jPanel2.add((Component)jRadioButton4, GBC.eop());
        jPanel2.add((Component)jCheckBox, GBC.eol());
        if (Main.pref.getBoolean("expert", false)) {
            jPanel2.add((Component)jCheckBox2, GBC.eol());
            jPanel2.add((Component)jCheckBox3, GBC.eop());
            jPanel2.add((Component)jRadioButton5, GBC.eol());
            jPanel2.add((Component)jRadioButton6, GBC.eol());
            jPanel2.add((Component)jRadioButton7, GBC.eol());
        }
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        SearchAction.buildHints(jPanel3, historyComboBox);
        JTextField jTextField = historyComboBox.getEditorComponent();
        jTextField.getDocument().addDocumentListener(new AbstractTextComponentValidator(jTextField){

            @Override
            public void validate() {
                if (!this.isValid()) {
                    this.feedbackInvalid(I18n.tr("Invalid search expression", new Object[0]));
                } else {
                    this.feedbackValid(string);
                }
            }

            @Override
            public boolean isValid() {
                try {
                    SearchSetting searchSetting = new SearchSetting();
                    searchSetting.text = historyComboBox.getText();
                    searchSetting.caseSensitive = jCheckBox.isSelected();
                    searchSetting.regexSearch = jRadioButton6.isSelected();
                    searchSetting.mapCSSSearch = jRadioButton7.isSelected();
                    SearchCompiler.compile(searchSetting);
                    return true;
                }
                catch (SearchCompiler.ParseError | MapCSSException exception) {
                    return false;
                }
            }
        });
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)jPanel, GBC.eol().fill(2).insets(5, 5, 5, 0));
        jPanel4.add((Component)jPanel2, GBC.std().anchor(11).insets(5, 10, 10, 0));
        jPanel4.add((Component)jPanel3, GBC.eol());
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, searchSetting instanceof Filter ? I18n.tr("Filter", new Object[0]) : I18n.tr("Search", new Object[0]), new String[]{searchSetting instanceof Filter ? I18n.tr("Submit filter", new Object[0]) : I18n.tr("Start Search", new Object[0]), I18n.tr("Cancel", new Object[0])}){

            @Override
            protected void buttonAction(int n, ActionEvent actionEvent) {
                if (n == 0) {
                    try {
                        SearchSetting searchSetting = new SearchSetting();
                        searchSetting.text = historyComboBox.getText();
                        searchSetting.caseSensitive = jCheckBox.isSelected();
                        searchSetting.regexSearch = jRadioButton6.isSelected();
                        searchSetting.mapCSSSearch = jRadioButton7.isSelected();
                        SearchCompiler.compile(searchSetting);
                        super.buttonAction(n, actionEvent);
                    }
                    catch (SearchCompiler.ParseError parseError) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Search expression is not valid: \n\n {0}", parseError.getMessage()), I18n.tr("Invalid search expression", new Object[0]), 0);
                    }
                } else {
                    super.buttonAction(n, actionEvent);
                }
            }
        };
        extendedDialog.setButtonIcons(new String[]{"dialogs/search", "cancel"});
        extendedDialog.configureContextsensitiveHelp("/Action/Search", true);
        extendedDialog.setContent(jPanel4);
        extendedDialog.showDialog();
        int n = extendedDialog.getValue();
        if (n != 1) {
            return null;
        }
        SearchMode searchMode = jRadioButton.isSelected() ? SearchMode.replace : (jRadioButton2.isSelected() ? SearchMode.add : (jRadioButton3.isSelected() ? SearchMode.remove : SearchMode.in_selection));
        searchSetting.text = historyComboBox.getText();
        searchSetting.mode = searchMode;
        searchSetting.caseSensitive = jCheckBox.isSelected();
        searchSetting.allElements = jCheckBox2.isSelected();
        searchSetting.regexSearch = jRadioButton6.isSelected();
        searchSetting.mapCSSSearch = jRadioButton7.isSelected();
        if (jCheckBox3.isSelected()) {
            ToolbarPreferences.ActionDefinition actionDefinition = new ToolbarPreferences.ActionDefinition(Main.main.menu.search);
            actionDefinition.getParameters().put(SEARCH_EXPRESSION, searchSetting);
            actionDefinition.setName(Utils.shortenString(searchSetting.text, 100));
            ToolbarPreferences.ActionParser actionParser = new ToolbarPreferences.ActionParser(null);
            String string2 = actionParser.saveAction(actionDefinition);
            Main.toolbar.addCustomButton(string2, -1, false);
        }
        return searchSetting;
    }

    private static void buildHints(JPanel jPanel, HistoryComboBox historyComboBox) {
        jPanel.add((Component)new SearchKeywordRow(historyComboBox).addTitle(I18n.tr("basic examples", new Object[0])).addKeyword(I18n.tr("Baker Street", new Object[0]), null, I18n.tr("''Baker'' and ''Street'' in any key", new Object[0]), new String[0]).addKeyword(I18n.tr("\"Baker Street\"", new Object[0]), "\"\"", I18n.tr("''Baker Street'' in any key", new Object[0]), new String[0]), GBC.eol());
        jPanel.add((Component)new SearchKeywordRow(historyComboBox).addTitle(I18n.tr("basics", new Object[0])).addKeyword("<i>key</i>:<i>valuefragment</i>", null, I18n.tr("''valuefragment'' anywhere in ''key''", new Object[0]), "name:str matches name=Bakerstreet").addKeyword("-<i>key</i>:<i>valuefragment</i>", null, I18n.tr("''valuefragment'' nowhere in ''key''", new Object[0]), new String[0]).addKeyword("<i>key</i>=<i>value</i>", null, I18n.tr("''key'' with exactly ''value''", new Object[0]), new String[0]).addKeyword("<i>key</i>=*", null, I18n.tr("''key'' with any value", new Object[0]), new String[0]).addKeyword("*=<i>value</i>", null, I18n.tr("''value'' in any key", new Object[0]), new String[0]).addKeyword("<i>key</i>=", null, I18n.tr("matches if ''key'' exists", new Object[0]), new String[0]).addKeyword("<i>key</i>><i>value</i>", null, I18n.tr("matches if ''key'' is greater than ''value'' (analogously, less than)", new Object[0]), new String[0]).addKeyword("\"key\"=\"value\"", "\"\"=\"\"", I18n.tr("to quote operators.<br>Within quoted strings the <b>\"</b> and <b>\\</b> characters need to be escaped by a preceding <b>\\</b> (e.g. <b>\\\"</b> and <b>\\\\</b>).", new Object[0]), "\"addr:street\""), GBC.eol());
        jPanel.add((Component)new SearchKeywordRow(historyComboBox).addTitle(I18n.tr("combinators", new Object[0])).addKeyword("<i>expr</i> <i>expr</i>", null, I18n.tr("logical and (both expressions have to be satisfied)", new Object[0]), new String[0]).addKeyword("<i>expr</i> | <i>expr</i>", "| ", I18n.tr("logical or (at least one expression has to be satisfied)", new Object[0]), new String[0]).addKeyword("<i>expr</i> OR <i>expr</i>", "OR ", I18n.tr("logical or (at least one expression has to be satisfied)", new Object[0]), new String[0]).addKeyword("-<i>expr</i>", null, I18n.tr("logical not", new Object[0]), new String[0]).addKeyword("(<i>expr</i>)", "()", I18n.tr("use parenthesis to group expressions", new Object[0]), new String[0]), GBC.eol());
        if (Main.pref.getBoolean("expert", false)) {
            jPanel.add((Component)new SearchKeywordRow(historyComboBox).addTitle(I18n.tr("objects", new Object[0])).addKeyword("type:node", "type:node ", I18n.tr("all ways", new Object[0]), new String[0]).addKeyword("type:way", "type:way ", I18n.tr("all ways", new Object[0]), new String[0]).addKeyword("type:relation", "type:relation ", I18n.tr("all relations", new Object[0]), new String[0]).addKeyword("closed", "closed ", I18n.tr("all closed ways", new Object[0]), new String[0]).addKeyword("untagged", "untagged ", I18n.tr("object without useful tags", new Object[0]), new String[0]), GBC.eol());
            jPanel.add((Component)new SearchKeywordRow(historyComboBox).addTitle(I18n.tr("metadata", new Object[0])).addKeyword("user:", "user:", I18n.tr("objects changed by user", "user:anonymous"), new String[0]).addKeyword("id:", "id:", I18n.tr("objects with given ID", new Object[0]), "id:0 (new objects)").addKeyword("version:", "version:", I18n.tr("objects with given version", new Object[0]), "version:0 (objects without an assigned version)").addKeyword("changeset:", "changeset:", I18n.tr("objects with given changeset ID", new Object[0]), "changeset:0 (objects without an assigned changeset)").addKeyword("timestamp:", "timestamp:", I18n.tr("objects with last modification timestamp within range", new Object[0]), "timestamp:2012/", "timestamp:2008/2011-02-04T12"), GBC.eol());
            jPanel.add((Component)new SearchKeywordRow(historyComboBox).addTitle(I18n.tr("properties", new Object[0])).addKeyword("nodes:<i>20-</i>", "nodes:", I18n.tr("ways with at least 20 nodes, or relations containing at least 20 nodes", new Object[0]), new String[0]).addKeyword("ways:<i>3-</i>", "ways:", I18n.tr("nodes with at least 3 referring ways, or relations containing at least 3 ways", new Object[0]), new String[0]).addKeyword("tags:<i>5-10</i>", "tags:", I18n.tr("objects having 5 to 10 tags", new Object[0]), new String[0]).addKeyword("role:", "role:", I18n.tr("objects with given role in a relation", new Object[0]), new String[0]).addKeyword("areasize:<i>-100</i>", "areasize:", I18n.tr("closed ways with an area of 100 m\u00b2", new Object[0]), new String[0]).addKeyword("waylength:<i>200-</i>", "waylength:", I18n.tr("ways with a length of 200 m or more", new Object[0]), new String[0]), GBC.eol());
            jPanel.add((Component)new SearchKeywordRow(historyComboBox).addTitle(I18n.tr("state", new Object[0])).addKeyword("modified", "modified ", I18n.tr("all modified objects", new Object[0]), new String[0]).addKeyword("new", "new ", I18n.tr("all new objects", new Object[0]), new String[0]).addKeyword("selected", "selected ", I18n.tr("all selected objects", new Object[0]), new String[0]).addKeyword("incomplete", "incomplete ", I18n.tr("all incomplete objects", new Object[0]), new String[0]), GBC.eol());
            jPanel.add((Component)new SearchKeywordRow(historyComboBox).addTitle(I18n.tr("related objects", new Object[0])).addKeyword("child <i>expr</i>", "child ", I18n.tr("all children of objects matching the expression", new Object[0]), "child building").addKeyword("parent <i>expr</i>", "parent ", I18n.tr("all parents of objects matching the expression", new Object[0]), "parent bus_stop").addKeyword("hasRole:<i>stop</i>", "hasRole:", I18n.tr("relation containing a member of role <i>stop</i>", new Object[0]), new String[0]).addKeyword("role:<i>stop</i>", "role:", I18n.tr("objects being part of a relation as role <i>stop</i>", new Object[0]), new String[0]).addKeyword("nth:<i>7</i>", "nth:", I18n.tr("n-th member of relation and/or n-th node of way", new Object[0]), "nth:5 (child type:relation)", "nth:-1").addKeyword("nth%:<i>7</i>", "nth%:", I18n.tr("every n-th member of relation and/or every n-th node of way", new Object[0]), "nth%:100 (child waterway)"), GBC.eol());
            jPanel.add((Component)new SearchKeywordRow(historyComboBox).addTitle(I18n.tr("view", new Object[0])).addKeyword("inview", "inview ", I18n.tr("objects in current view", new Object[0]), new String[0]).addKeyword("allinview", "allinview ", I18n.tr("objects (and all its way nodes / relation members) in current view", new Object[0]), new String[0]).addKeyword("indownloadedarea", "indownloadedarea ", I18n.tr("objects in downloaded area", new Object[0]), new String[0]).addKeyword("allindownloadedarea", "allindownloadedarea ", I18n.tr("objects (and all its way nodes / relation members) in downloaded area", new Object[0]), new String[0]), GBC.eol());
        }
    }

    public static void search() {
        SearchSetting searchSetting = SearchAction.showSearchDialog(lastSearch);
        if (searchSetting != null) {
            SearchAction.searchWithHistory(searchSetting);
        }
    }

    public static void searchWithHistory(SearchSetting searchSetting) {
        SearchAction.saveToHistory(searchSetting);
        lastSearch = new SearchSetting(searchSetting);
        SearchAction.search(searchSetting);
    }

    public static void searchWithoutHistory(SearchSetting searchSetting) {
        lastSearch = new SearchSetting(searchSetting);
        SearchAction.search(searchSetting);
    }

    public static void search(String string, SearchMode searchMode) {
        SearchSetting searchSetting = new SearchSetting();
        searchSetting.text = string;
        searchSetting.mode = searchMode;
        SearchAction.search(searchSetting);
    }

    static void search(SearchSetting searchSetting) {
        SearchTask.newSearchTask(searchSetting).run();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(SearchAction.getEditLayer() != null);
    }

    @Override
    public List<ActionParameter<?>> getActionParameters() {
        return Collections.singletonList(new ActionParameter.SearchSettingsActionParameter(SEARCH_EXPRESSION));
    }

    static {
        for (String string : Main.pref.getCollection("search.history", Collections.emptyList())) {
            SearchSetting searchSetting = SearchSetting.readFromString(string);
            if (searchSetting == null) continue;
            searchHistory.add(searchSetting);
        }
    }

    public static class SearchSetting {
        public String text;
        public SearchMode mode;
        public boolean caseSensitive;
        public boolean regexSearch;
        public boolean mapCSSSearch;
        public boolean allElements;

        public SearchSetting() {
            this.text = "";
            this.mode = SearchMode.replace;
        }

        public SearchSetting(SearchSetting searchSetting) {
            this.text = searchSetting.text;
            this.mode = searchSetting.mode;
            this.caseSensitive = searchSetting.caseSensitive;
            this.regexSearch = searchSetting.regexSearch;
            this.mapCSSSearch = searchSetting.mapCSSSearch;
            this.allElements = searchSetting.allElements;
        }

        public String toString() {
            String string = this.caseSensitive ? I18n.trc("search", "CS") : I18n.trc("search", "CI");
            String string2 = this.regexSearch ? ", " + I18n.trc("search", "RX") : "";
            String string3 = this.mapCSSSearch ? ", " + I18n.trc("search", "CSS") : "";
            String string4 = this.allElements ? ", " + I18n.trc("search", "A") : "";
            return '\"' + this.text + "\" (" + string + string2 + string3 + string4 + ", " + (Object)((Object)this.mode) + ')';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SearchSetting searchSetting = (SearchSetting)object;
            return this.caseSensitive == searchSetting.caseSensitive && this.regexSearch == searchSetting.regexSearch && this.mapCSSSearch == searchSetting.mapCSSSearch && this.allElements == searchSetting.allElements && Objects.equals(this.text, searchSetting.text) && this.mode == searchSetting.mode;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.text, this.mode, this.caseSensitive, this.regexSearch, this.mapCSSSearch, this.allElements});
        }

        public static SearchSetting readFromString(String string) {
            if (string.isEmpty()) {
                return null;
            }
            SearchSetting searchSetting = new SearchSetting();
            int n = 1;
            searchSetting.mode = SearchMode.fromCode(string.charAt(0));
            if (searchSetting.mode == null) {
                searchSetting.mode = SearchMode.replace;
                n = 0;
            }
            while (n < string.length()) {
                if (string.charAt(n) == 'C') {
                    searchSetting.caseSensitive = true;
                } else if (string.charAt(n) == 'R') {
                    searchSetting.regexSearch = true;
                } else if (string.charAt(n) == 'A') {
                    searchSetting.allElements = true;
                } else if (string.charAt(n) == 'M') {
                    searchSetting.mapCSSSearch = true;
                } else {
                    if (string.charAt(n) == ' ') break;
                    Main.warn("Unknown char in SearchSettings: " + string);
                    break;
                }
                ++n;
            }
            if (n < string.length() && string.charAt(n) == ' ') {
                ++n;
            }
            searchSetting.text = string.substring(n);
            return searchSetting;
        }

        public String writeToString() {
            if (this.text == null || this.text.isEmpty()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.mode.getCode());
            if (this.caseSensitive) {
                stringBuilder.append('C');
            }
            if (this.regexSearch) {
                stringBuilder.append('R');
            }
            if (this.mapCSSSearch) {
                stringBuilder.append('M');
            }
            if (this.allElements) {
                stringBuilder.append('A');
            }
            stringBuilder.append(' ').append(this.text);
            return stringBuilder.toString();
        }
    }

    static final class SearchTask
    extends PleaseWaitRunnable {
        private final DataSet ds;
        private final SearchSetting setting;
        private final Collection<OsmPrimitive> selection;
        private final Predicate<OsmPrimitive> predicate;
        private boolean canceled;
        private int foundMatches;

        private SearchTask(DataSet dataSet, SearchSetting searchSetting, Collection<OsmPrimitive> collection, Predicate<OsmPrimitive> predicate) {
            super(I18n.tr("Searching", new Object[0]));
            this.ds = dataSet;
            this.setting = searchSetting;
            this.selection = collection;
            this.predicate = predicate;
        }

        static SearchTask newSearchTask(SearchSetting searchSetting) {
            final DataSet dataSet = Main.main.getCurrentDataSet();
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(dataSet.getAllSelected());
            return new SearchTask(dataSet, searchSetting, hashSet, new Predicate<OsmPrimitive>(){

                @Override
                public boolean evaluate(OsmPrimitive osmPrimitive) {
                    return dataSet.isSelected(osmPrimitive);
                }
            });
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void realRun() {
            try {
                this.foundMatches = 0;
                SearchCompiler.Match match = SearchCompiler.compile(this.setting);
                if (this.setting.mode == SearchMode.replace) {
                    this.selection.clear();
                } else if (this.setting.mode == SearchMode.in_selection) {
                    this.foundMatches = this.selection.size();
                }
                Collection<OsmPrimitive> collection = this.setting.allElements ? Main.main.getCurrentDataSet().allPrimitives() : Main.main.getCurrentDataSet().allNonDeletedCompletePrimitives();
                ProgressMonitor progressMonitor = this.getProgressMonitor().createSubTaskMonitor(collection.size(), false);
                progressMonitor.beginTask(I18n.trn("Searching in {0} object", "Searching in {0} objects", collection.size(), collection.size()));
                for (OsmPrimitive osmPrimitive : collection) {
                    if (this.canceled) {
                        return;
                    }
                    if (this.setting.mode == SearchMode.replace) {
                        if (match.match(osmPrimitive)) {
                            this.selection.add(osmPrimitive);
                            ++this.foundMatches;
                        }
                    } else if (this.setting.mode == SearchMode.add && !this.predicate.evaluate(osmPrimitive) && match.match(osmPrimitive)) {
                        this.selection.add(osmPrimitive);
                        ++this.foundMatches;
                    } else if (this.setting.mode == SearchMode.remove && this.predicate.evaluate(osmPrimitive) && match.match(osmPrimitive)) {
                        this.selection.remove(osmPrimitive);
                        ++this.foundMatches;
                    } else if (this.setting.mode == SearchMode.in_selection && this.predicate.evaluate(osmPrimitive) && !match.match(osmPrimitive)) {
                        this.selection.remove(osmPrimitive);
                        --this.foundMatches;
                    }
                    progressMonitor.worked(1);
                }
                progressMonitor.finishTask();
            }
            catch (SearchCompiler.ParseError parseError) {
                JOptionPane.showMessageDialog(Main.parent, parseError.getMessage(), I18n.tr("Error", new Object[0]), 0);
            }
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            this.ds.setSelected(this.selection);
            if (this.foundMatches == 0) {
                String string = Utils.shortenString(this.setting.text, 100);
                String string2 = this.setting.mode == SearchMode.replace ? I18n.tr("No match found for ''{0}''", string) : (this.setting.mode == SearchMode.add ? I18n.tr("Nothing added to selection by searching for ''{0}''", string) : (this.setting.mode == SearchMode.remove ? I18n.tr("Nothing removed from selection by searching for ''{0}''", string) : (this.setting.mode == SearchMode.in_selection ? I18n.tr("Nothing found in selection by searching for ''{0}''", string) : null)));
                Main.map.statusLine.setHelpText(string2);
                JOptionPane.showMessageDialog(Main.parent, string2, I18n.tr("Warning", new Object[0]), 2);
            } else {
                Main.map.statusLine.setHelpText(I18n.tr("Found {0} matches", this.foundMatches));
            }
        }
    }

    private static class SearchKeywordRow
    extends JPanel {
        private final HistoryComboBox hcb;

        SearchKeywordRow(HistoryComboBox historyComboBox) {
            super(new FlowLayout(0));
            this.hcb = historyComboBox;
        }

        public SearchKeywordRow addTitle(String string) {
            this.add(new JLabel(I18n.tr("{0}: ", string)));
            return this;
        }

        public SearchKeywordRow addKeyword(String string, final String string2, String string3, String ... stringArray) {
            JLabel jLabel = new JLabel("<html><style>td{border:1px solid gray; font-weight:normal;}</style><table><tr><td>" + string + "</td></tr></table></html>");
            this.add(jLabel);
            if (string3 != null || stringArray.length > 0) {
                jLabel.setToolTipText("<html>" + string3 + (stringArray.length > 0 ? Utils.joinAsHtmlUnorderedList(Arrays.asList(stringArray)) : "") + "</html>");
            }
            if (string2 != null) {
                jLabel.setCursor(Cursor.getPredefinedCursor(12));
                jLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        try {
                            JTextField jTextField = SearchKeywordRow.this.hcb.getEditorComponent();
                            jTextField.getDocument().insertString(jTextField.getCaretPosition(), ' ' + string2, null);
                        }
                        catch (BadLocationException badLocationException) {
                            throw new RuntimeException(badLocationException.getMessage(), badLocationException);
                        }
                    }
                });
            }
            return this;
        }
    }

    private static class DescriptionTextBuilder {
        private final StringBuilder s = new StringBuilder(4096);

        private DescriptionTextBuilder() {
        }

        public StringBuilder append(String string) {
            return this.s.append(string);
        }

        StringBuilder appendItem(String string) {
            return this.append("<li>").append(string).append("</li>\n");
        }

        StringBuilder appendItemHeader(String string) {
            return this.append("<li class=\"header\">").append(string).append("</li>\n");
        }

        public String toString() {
            return this.s.toString();
        }
    }

    public static enum SearchMode {
        replace('R'),
        add('A'),
        remove('D'),
        in_selection('S');

        private final char code;

        private SearchMode(char c) {
            this.code = c;
        }

        public char getCode() {
            return this.code;
        }

        public static SearchMode fromCode(char c) {
            for (SearchMode searchMode : SearchMode.values()) {
                if (searchMode.getCode() != c) continue;
                return searchMode;
            }
            return null;
        }
    }
}

