/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.platform.posix;

import java.io.FileDescriptor;
import java.nio.ByteBuffer;
import java.util.Collection;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.Signal;
import jnr.constants.platform.Sysconf;
import jnr.ffi.Pointer;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import jnr.posix.Passwd;
import jnr.posix.SignalHandler;
import jnr.posix.SpawnFileAction;
import jnr.posix.Times;
import org.jruby.truffle.platform.posix.TrufflePosix;

public class JNRTrufflePosix
implements TrufflePosix {
    private final POSIX posix;

    public JNRTrufflePosix(POSIX posix) {
        this.posix = posix;
    }

    protected POSIX getPosix() {
        return this.posix;
    }

    @Override
    public byte[] crypt(byte[] key, byte[] salt) {
        return this.posix.crypt(key, salt);
    }

    @Override
    public FileStat allocateStat() {
        return this.posix.allocateStat();
    }

    @Override
    public int chmod(String filename, int mode) {
        return this.posix.chmod(filename, mode);
    }

    @Override
    public int fchmod(int fd, int mode) {
        return this.posix.fchmod(fd, mode);
    }

    @Override
    public int chown(String filename, int user, int group) {
        return this.posix.chown(filename, user, group);
    }

    @Override
    public int fchown(int fd, int user, int group) {
        return this.posix.fchown(fd, user, group);
    }

    @Override
    public int exec(String path, String ... argv) {
        return this.posix.exec(path, argv);
    }

    @Override
    public int exec(String path, String[] argv, String[] envp) {
        return this.posix.exec(path, argv, envp);
    }

    @Override
    public int fork() {
        return this.posix.fork();
    }

    @Override
    public int fstat(int fd, FileStat stat) {
        return this.posix.fstat(fd, stat);
    }

    @Override
    public Pointer environ() {
        return this.posix.environ();
    }

    @Override
    public String getenv(String envName) {
        return this.posix.getenv(envName);
    }

    @Override
    public int getegid() {
        return this.posix.getegid();
    }

    @Override
    public int geteuid() {
        return this.posix.geteuid();
    }

    @Override
    public int seteuid(int euid) {
        return this.posix.seteuid(euid);
    }

    @Override
    public int getgid() {
        return this.posix.getgid();
    }

    @Override
    public int getpgid(int pid) {
        return this.posix.getpgid(pid);
    }

    @Override
    public int getpgrp() {
        return this.posix.getpgrp();
    }

    @Override
    public int getpid() {
        return this.posix.getpid();
    }

    @Override
    public int getppid() {
        return this.posix.getppid();
    }

    @Override
    public int getpriority(int which, int who) {
        return this.posix.getpriority(which, who);
    }

    @Override
    public Passwd getpwnam(String which) {
        return this.posix.getpwnam(which);
    }

    @Override
    public int getuid() {
        return this.posix.getuid();
    }

    @Override
    public int getrlimit(int resource, Pointer rlim) {
        return this.posix.getrlimit(resource, rlim);
    }

    @Override
    public int setrlimit(int resource, Pointer rlim) {
        return this.posix.setrlimit(resource, rlim);
    }

    @Override
    public boolean isatty(FileDescriptor descriptor) {
        return this.posix.isatty(descriptor);
    }

    @Override
    public int kill(int pid, int signal) {
        return this.posix.kill(pid, signal);
    }

    @Override
    public int kill(long pid, int signal) {
        return this.posix.kill(pid, signal);
    }

    @Override
    public SignalHandler signal(Signal sig, SignalHandler handler) {
        return this.posix.signal(sig, handler);
    }

    @Override
    public int link(String oldpath, String newpath) {
        return this.posix.link(oldpath, newpath);
    }

    public FileStat lstat(String path) {
        return this.posix.lstat(path);
    }

    @Override
    public int lstat(String path, FileStat stat) {
        return this.posix.lstat(path, stat);
    }

    @Override
    public int mkdir(String path, int mode) {
        return this.posix.mkdir(path, mode);
    }

    @Override
    public int readlink(CharSequence path, Pointer bufPtr, int bufsize) {
        return this.posix.readlink(path, bufPtr, bufsize);
    }

    @Override
    public int rmdir(String path) {
        return this.posix.rmdir(path);
    }

    @Override
    public int setenv(String envName, String envValue, int overwrite) {
        return this.posix.setenv(envName, envValue, overwrite);
    }

    @Override
    public int setsid() {
        return this.posix.setsid();
    }

    @Override
    public int setgid(int gid) {
        return this.posix.setgid(gid);
    }

    @Override
    public int setpriority(int which, int who, int prio) {
        return this.posix.setpriority(which, who, prio);
    }

    @Override
    public int setuid(int uid) {
        return this.posix.setuid(uid);
    }

    @Override
    public FileStat stat(String path) {
        return this.posix.stat(path);
    }

    @Override
    public int stat(String path, FileStat stat) {
        return this.posix.stat(path, stat);
    }

    @Override
    public int symlink(String oldpath, String newpath) {
        return this.posix.symlink(oldpath, newpath);
    }

    @Override
    public int umask(int mask) {
        return this.posix.umask(mask);
    }

    @Override
    public int unsetenv(String envName) {
        return this.posix.unsetenv(envName);
    }

    @Override
    public int utimes(String path, Pointer times) {
        return this.posix.utimes(path, times);
    }

    @Override
    public int waitpid(int pid, int[] status, int flags) {
        return this.posix.waitpid(pid, status, flags);
    }

    @Override
    public int waitpid(long pid, int[] status, int flags) {
        return this.posix.waitpid(pid, status, flags);
    }

    @Override
    public int wait(int[] status) {
        return this.posix.wait(status);
    }

    @Override
    public int errno() {
        return this.posix.errno();
    }

    @Override
    public void errno(int value) {
        this.posix.errno(value);
    }

    @Override
    public int chdir(String path) {
        return this.posix.chdir(path);
    }

    @Override
    public long sysconf(Sysconf name) {
        return this.posix.sysconf(name);
    }

    @Override
    public Times times() {
        return this.posix.times();
    }

    @Override
    public long posix_spawnp(String path, Collection<? extends SpawnFileAction> fileActions, Collection<? extends CharSequence> argv, Collection<? extends CharSequence> envp) {
        return this.posix.posix_spawnp(path, fileActions, argv, envp);
    }

    @Override
    public int flock(int fd, int operation) {
        return this.posix.flock(fd, operation);
    }

    @Override
    public int dup(int fd) {
        return this.posix.dup(fd);
    }

    @Override
    public int dup2(int oldFd, int newFd) {
        return this.posix.dup2(oldFd, newFd);
    }

    @Override
    public int fcntlInt(int fd, Fcntl fcntlConst, int arg) {
        return this.posix.fcntlInt(fd, fcntlConst, arg);
    }

    @Override
    public int fcntl(int fd, Fcntl fcntlConst) {
        return this.posix.fcntl(fd, fcntlConst);
    }

    @Override
    public int access(CharSequence path, int amode) {
        return this.posix.access(path, amode);
    }

    @Override
    public int close(int fd) {
        return this.posix.close(fd);
    }

    @Override
    public int unlink(CharSequence path) {
        return this.posix.unlink(path);
    }

    @Override
    public int open(CharSequence path, int flags, int perm) {
        return this.posix.open(path, flags, perm);
    }

    @Override
    public int write(int fd, byte[] buf, int n) {
        return this.posix.write(fd, buf, n);
    }

    @Override
    public int read(int fd, byte[] buf, int n) {
        return this.posix.read(fd, buf, n);
    }

    @Override
    public int write(int fd, ByteBuffer buf, int n) {
        return this.posix.write(fd, buf, n);
    }

    @Override
    public int read(int fd, ByteBuffer buf, int n) {
        return this.posix.read(fd, buf, n);
    }

    @Override
    public int lseek(int fd, long offset, int whence) {
        return this.posix.lseek(fd, offset, whence);
    }

    @Override
    public int pipe(int[] fds) {
        return this.posix.pipe(fds);
    }

    @Override
    public int truncate(CharSequence path, long length) {
        return this.posix.truncate(path, length);
    }

    @Override
    public int ftruncate(int fd, long offset) {
        return this.posix.ftruncate(fd, offset);
    }

    @Override
    public int rename(CharSequence oldName, CharSequence newName) {
        return this.posix.rename(oldName, newName);
    }

    @Override
    public String getcwd() {
        return this.posix.getcwd();
    }

    @Override
    public int fsync(int fd) {
        return this.posix.fsync(fd);
    }

    @Override
    public int isatty(int fd) {
        return this.posix.libc().isatty(fd);
    }
}

