/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.OrderedFigureElement;
import CH.ifa.draw.standard.QuadTree;
import CH.ifa.draw.standard.ReverseFigureEnumerator;
import CH.ifa.draw.util.Bounds;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public abstract class CompositeFigure
extends AbstractFigure
implements FigureChangeListener {
    protected Vector fFigures = new Vector();
    private static final long serialVersionUID = 7408153435700021866L;
    private int compositeFigureSerializedDataVersion = 1;
    private QuadTree _theQuadTree;
    protected int _nLowestZ = 0;
    protected int _nHighestZ = 0;

    protected CompositeFigure() {
    }

    public Figure add(Figure figure) {
        if (!this.fFigures.contains(figure)) {
            figure.setZValue(++this._nHighestZ);
            this.fFigures.addElement(figure);
            figure.addToContainer(this);
            this._addToQuadTree(figure);
        }
        return figure;
    }

    public void addAll(Vector newFigures) {
        this.addAll(new FigureEnumerator(newFigures));
    }

    public void addAll(FigureEnumeration fe) {
        while (fe.hasMoreElements()) {
            this.add(fe.nextFigure());
        }
    }

    public Figure remove(Figure figure) {
        return this.orphan(figure);
    }

    public void removeAll(Vector figures) {
        this.removeAll(new FigureEnumerator(figures));
    }

    public void removeAll(FigureEnumeration fe) {
        while (fe.hasMoreElements()) {
            this.remove(fe.nextFigure());
        }
    }

    public void removeAll() {
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure figure = fe.nextFigure();
            figure.removeFromContainer(this);
        }
        this.fFigures.removeAllElements();
        this._clearQuadTree();
        this._nLowestZ = 0;
        this._nHighestZ = 0;
    }

    public synchronized Figure orphan(Figure figure) {
        if (this.fFigures.contains(figure)) {
            figure.removeFromContainer(this);
            this.fFigures.removeElement(figure);
            this._removeFromQuadTree(figure);
        }
        return figure;
    }

    public void orphanAll(Vector newFigures) {
        this.orphanAll(new FigureEnumerator(newFigures));
    }

    public void orphanAll(FigureEnumeration fe) {
        while (fe.hasMoreElements()) {
            this.orphan(fe.nextFigure());
        }
    }

    public synchronized Figure replace(Figure figure, Figure replacement) {
        int index = this.fFigures.indexOf(figure);
        if (index != -1) {
            replacement.setZValue(figure.getZValue());
            replacement.addToContainer(this);
            figure.removeFromContainer(this);
            this.fFigures.setElementAt(replacement, index);
            figure.changed();
            replacement.changed();
        }
        return replacement;
    }

    public synchronized void sendToBack(Figure figure) {
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            this.fFigures.insertElementAt(figure, 0);
            --this._nLowestZ;
            figure.setZValue(this._nLowestZ);
            figure.changed();
        }
    }

    public synchronized void bringToFront(Figure figure) {
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            this.fFigures.addElement(figure);
            ++this._nHighestZ;
            figure.setZValue(this._nHighestZ);
            figure.changed();
        }
    }

    public void sendToLayer(Figure figure, int layerNr) {
        if (this.fFigures.contains(figure)) {
            if (layerNr >= this.fFigures.size()) {
                layerNr = this.fFigures.size() - 1;
            }
            Figure layerFigure = this.getFigureFromLayer(layerNr);
            int layerFigureZValue = layerFigure.getZValue();
            int figureLayer = this.getLayer(figure);
            if (figureLayer < layerNr) {
                this.assignFiguresToPredecessorZValue(figureLayer + 1, layerNr);
            } else if (figureLayer > layerNr) {
                this.assignFiguresToSuccessorZValue(layerNr, figureLayer - 1);
            }
            this.fFigures.removeElement(figure);
            this.fFigures.insertElementAt(figure, layerNr);
            figure.setZValue(layerFigureZValue);
            figure.changed();
        }
    }

    private void assignFiguresToPredecessorZValue(int lowerBound, int upperBound) {
        if (upperBound >= this.fFigures.size()) {
            upperBound = this.fFigures.size() - 1;
        }
        for (int i = upperBound; i >= lowerBound; --i) {
            Figure currentFigure = (Figure)this.fFigures.elementAt(i);
            Figure predecessorFigure = (Figure)this.fFigures.elementAt(i - 1);
            currentFigure.setZValue(predecessorFigure.getZValue());
        }
    }

    private void assignFiguresToSuccessorZValue(int lowerBound, int upperBound) {
        if (upperBound >= this.fFigures.size()) {
            upperBound = this.fFigures.size() - 1;
        }
        for (int i = upperBound; i >= lowerBound; --i) {
            Figure currentFigure = (Figure)this.fFigures.elementAt(i);
            Figure successorFigure = (Figure)this.fFigures.elementAt(i + 1);
            currentFigure.setZValue(successorFigure.getZValue());
        }
    }

    public int getLayer(Figure figure) {
        if (!this.fFigures.contains(figure)) {
            return -1;
        }
        return this.fFigures.indexOf(figure);
    }

    public Figure getFigureFromLayer(int layerNr) {
        if (layerNr >= 0 && layerNr < this.fFigures.size()) {
            return (Figure)this.fFigures.elementAt(layerNr);
        }
        return null;
    }

    public void draw(Graphics g) {
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            fe.nextFigure().draw(g);
        }
    }

    public void draw(Graphics g, FigureEnumeration fe) {
        while (fe.hasMoreElements()) {
            fe.nextFigure().draw(g);
        }
    }

    public Figure figureAt(int i) {
        return (Figure)this.fFigures.elementAt(i);
    }

    public final FigureEnumeration figures() {
        return new FigureEnumerator((Vector)this.fFigures.clone());
    }

    public FigureEnumeration figures(Rectangle viewRectangle) {
        if (this._theQuadTree != null) {
            Vector v = this._theQuadTree.getAllWithin(new Bounds(viewRectangle).asRectangle2D());
            Vector<OrderedFigureElement> v2 = new Vector<OrderedFigureElement>();
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                Figure f = (Figure)e.nextElement();
                v2.addElement(new OrderedFigureElement(f, f.getZValue()));
            }
            Collections.sort(v2);
            Vector<Figure> v3 = new Vector<Figure>();
            Enumeration e2 = v2.elements();
            while (e2.hasMoreElements()) {
                OrderedFigureElement ofe = (OrderedFigureElement)e2.nextElement();
                v3.addElement(ofe.getFigure());
            }
            return new FigureEnumerator(v3);
        }
        return this.figures();
    }

    public int figureCount() {
        return this.fFigures.size();
    }

    public final FigureEnumeration figuresReverse() {
        return new ReverseFigureEnumerator((Vector)this.fFigures.clone());
    }

    public Figure findFigure(int x, int y) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (!figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigure(Rectangle r) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            Rectangle fr = figure.displayBox();
            if (!r.intersects(fr)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureWithout(int x, int y, Figure without) {
        if (without == null) {
            return this.findFigure(x, y);
        }
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (!figure.containsPoint(x, y) || figure.includes(without)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigure(Rectangle r, Figure without) {
        if (without == null) {
            return this.findFigure(r);
        }
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            Rectangle fr = figure.displayBox();
            if (!r.intersects(fr) || figure.includes(without)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureInside(int x, int y) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure().findFigureInside(x, y);
            if (figure == null) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureInsideWithout(int x, int y, Figure without) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure found;
            Figure figure = k.nextFigure();
            if (figure == without || (found = figure.findFigureInside(x, y)) == null) continue;
            return found;
        }
        return null;
    }

    public boolean includes(Figure figure) {
        if (super.includes(figure)) {
            return true;
        }
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            if (!f.includes(figure)) continue;
            return true;
        }
        return false;
    }

    protected void basicMoveBy(int x, int y) {
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            fe.nextFigure().moveBy(x, y);
        }
    }

    public void release() {
        super.release();
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure figure = fe.nextFigure();
            figure.release();
        }
    }

    public void figureInvalidated(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureInvalidated(e);
        }
    }

    public void figureRequestRemove(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(e);
        }
    }

    public void figureChanged(FigureChangeEvent e) {
        this._removeFromQuadTree(e.getFigure());
        this._addToQuadTree(e.getFigure());
    }

    public void figureRemoved(FigureChangeEvent e) {
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.figureCount());
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            dw.writeStorable(fe.nextFigure());
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        int size = dr.readInt();
        this.fFigures = new Vector(size);
        for (int i = 0; i < size; ++i) {
            this.add((Figure)dr.readStorable());
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure figure = fe.nextFigure();
            figure.addToContainer(this);
        }
    }

    public void init(Rectangle viewRectangle) {
        this._theQuadTree = new QuadTree(new Bounds(viewRectangle).asRectangle2D());
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            this._addToQuadTree(fe.nextFigure());
        }
    }

    private void _addToQuadTree(Figure f) {
        if (this._theQuadTree != null) {
            this._theQuadTree.add(f, new Bounds(f.displayBox()).asRectangle2D());
        }
    }

    private void _removeFromQuadTree(Figure f) {
        if (this._theQuadTree != null) {
            this._theQuadTree.remove(f);
        }
    }

    private void _clearQuadTree() {
        if (this._theQuadTree != null) {
            this._theQuadTree.clear();
        }
    }
}

