/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view;

import ch.softenvironment.client.ResourceManager;
import ch.softenvironment.view.BaseFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PhoneNumberPanel
extends JPanel {
    private String separator = "/";
    private JTextField ivjTxtCountryPrefix = null;
    private JTextField ivjTxtNumber = null;
    private String fieldText = "";
    private JTextField ivjTxtSitePrefix = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private List fieldList = null;
    private JComboBox ivjCbxCount = null;

    public PhoneNumberPanel() {
        this.initialize();
    }

    private void connEtoC1(KeyEvent arg1) {
        try {
            this.setPhoneNumber();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(KeyEvent arg1) {
        try {
            this.setPhoneNumber();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(KeyEvent arg1) {
        try {
            this.setPhoneNumber();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(FocusEvent arg1) {
        try {
            this.getTxtCountryPrefix().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2(FocusEvent arg1) {
        try {
            this.getTxtSitePrefix().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM3(FocusEvent arg1) {
        try {
            this.getTxtNumber().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JComboBox getCbxCount() {
        if (this.ivjCbxCount == null) {
            try {
                this.ivjCbxCount = new JComboBox();
                this.ivjCbxCount.setName("CbxCount");
                this.ivjCbxCount.setBounds(230, 0, 63, 23);
                this.ivjCbxCount.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCbxCount;
    }

    public List getList() {
        return this.fieldList;
    }

    public String getText() {
        return this.fieldText;
    }

    private JTextField getTxtCountryPrefix() {
        if (this.ivjTxtCountryPrefix == null) {
            try {
                this.ivjTxtCountryPrefix = new JTextField();
                this.ivjTxtCountryPrefix.setName("TxtCountryPrefix");
                this.ivjTxtCountryPrefix.setToolTipText("Landesvorwahl");
                this.ivjTxtCountryPrefix.setAlignmentX(0.0f);
                this.ivjTxtCountryPrefix.setAlignmentY(0.0f);
                this.ivjTxtCountryPrefix.setBounds(0, 1, 45, 20);
                this.ivjTxtCountryPrefix.setNextFocusableComponent(this.getTxtSitePrefix());
                this.ivjTxtCountryPrefix.setToolTipText(ResourceManager.getResource(PhoneNumberPanel.class, "TxtCountryPrefix_toolTipText"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxtCountryPrefix;
    }

    private JTextField getTxtNumber() {
        if (this.ivjTxtNumber == null) {
            try {
                this.ivjTxtNumber = new JTextField();
                this.ivjTxtNumber.setName("TxtNumber");
                this.ivjTxtNumber.setToolTipText("Ortsnummer");
                this.ivjTxtNumber.setAlignmentX(0.0f);
                this.ivjTxtNumber.setAlignmentY(0.0f);
                this.ivjTxtNumber.setBounds(95, 1, 129, 20);
                this.ivjTxtNumber.setColumns(6);
                this.ivjTxtNumber.setToolTipText(ResourceManager.getResource(PhoneNumberPanel.class, "TxtNumber_toolTipText"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxtNumber;
    }

    private JTextField getTxtSitePrefix() {
        if (this.ivjTxtSitePrefix == null) {
            try {
                this.ivjTxtSitePrefix = new JTextField();
                this.ivjTxtSitePrefix.setName("TxtSitePrefix");
                this.ivjTxtSitePrefix.setToolTipText("Ortsvorwahl");
                this.ivjTxtSitePrefix.setAlignmentY(0.0f);
                this.ivjTxtSitePrefix.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
                this.ivjTxtSitePrefix.setAlignmentX(0.0f);
                this.ivjTxtSitePrefix.setBounds(48, 1, 43, 20);
                this.ivjTxtSitePrefix.setNextFocusableComponent(this.getTxtNumber());
                this.ivjTxtSitePrefix.setToolTipText(ResourceManager.getResource(PhoneNumberPanel.class, "TxtSitePrefix_toolTipText"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxtSitePrefix;
    }

    private void handleException(Throwable exception) {
        BaseFrame.showException(null, exception);
    }

    private void initConnections() throws Exception {
        this.getTxtSitePrefix().addKeyListener(this.ivjEventHandler);
        this.getTxtCountryPrefix().addKeyListener(this.ivjEventHandler);
        this.getTxtNumber().addKeyListener(this.ivjEventHandler);
        this.getTxtCountryPrefix().addFocusListener(this.ivjEventHandler);
        this.getTxtSitePrefix().addFocusListener(this.ivjEventHandler);
        this.getTxtNumber().addFocusListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("PhoneNumberPanel");
            this.setLayout(null);
            this.setSize(299, 24);
            this.add((Component)this.getTxtCountryPrefix(), this.getTxtCountryPrefix().getName());
            this.add((Component)this.getTxtSitePrefix(), this.getTxtSitePrefix().getName());
            this.add((Component)this.getTxtNumber(), this.getTxtNumber().getName());
            this.add((Component)this.getCbxCount(), this.getCbxCount().getName());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void setInternalText(String text) {
        String oldValue = this.fieldText;
        this.fieldText = text;
        this.firePropertyChange("text", oldValue, text);
        if (this.getList() != null) {
            if (this.getList().size() == 0) {
                this.getList().add(text);
            } else {
                this.getList().set(0, text);
            }
            this.firePropertyChange("list", null, this.getList());
        }
    }

    public void setList(List list) {
        List oldValue = this.fieldList;
        this.fieldList = list;
        this.firePropertyChange("list", oldValue, list);
        Vector<Integer> elements = new Vector<Integer>(1);
        elements.add(new Integer(1));
        this.getCbxCount().setModel(new DefaultComboBoxModel(elements));
        if (list != null && list.size() >= 1) {
            this.setText((String)list.get(0));
        }
    }

    private void setPhoneNumber() {
        this.setInternalText(this.getTxtCountryPrefix().getText() + this.separator + this.getTxtSitePrefix().getText() + this.separator + this.getTxtNumber().getText());
    }

    public void setText(String text) {
        if (text != null && text.length() > 0) {
            int countrySeparator = text.indexOf(this.separator);
            if (countrySeparator >= 0) {
                int siteSeparator;
                this.getTxtCountryPrefix().setText(text.substring(0, countrySeparator));
                if (text.length() > countrySeparator + 1 && (siteSeparator = text.indexOf(this.separator, countrySeparator + 1)) >= 0) {
                    this.getTxtSitePrefix().setText(text.substring(countrySeparator + 1, siteSeparator));
                    if (siteSeparator + 1 < text.length()) {
                        this.getTxtNumber().setText(text.substring(siteSeparator + 1, text.length()));
                    } else {
                        this.getTxtNumber().setText(null);
                    }
                }
            }
        } else {
            this.getTxtCountryPrefix().setText(null);
            this.getTxtSitePrefix().setText(null);
            this.getTxtNumber().setText(null);
        }
        this.setInternalText(text);
    }

    class IvjEventHandler
    implements FocusListener,
    KeyListener {
        IvjEventHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == PhoneNumberPanel.this.getTxtCountryPrefix()) {
                PhoneNumberPanel.this.connEtoM1(e);
            }
            if (e.getSource() == PhoneNumberPanel.this.getTxtSitePrefix()) {
                PhoneNumberPanel.this.connEtoM2(e);
            }
            if (e.getSource() == PhoneNumberPanel.this.getTxtNumber()) {
                PhoneNumberPanel.this.connEtoM3(e);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getSource() == PhoneNumberPanel.this.getTxtSitePrefix()) {
                PhoneNumberPanel.this.connEtoC2(e);
            }
            if (e.getSource() == PhoneNumberPanel.this.getTxtCountryPrefix()) {
                PhoneNumberPanel.this.connEtoC1(e);
            }
            if (e.getSource() == PhoneNumberPanel.this.getTxtNumber()) {
                PhoneNumberPanel.this.connEtoC3(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

