/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class HttpResponseHeader
extends HttpHeader {
    private static final long serialVersionUID = 2812716126742059785L;
    private static final Logger log = Logger.getLogger(HttpResponseHeader.class);
    public static final String HTTP_CLIENT_BAD_REQUEST = "HTTP/1.0 400 Bad request\r\n\r\n";
    private static final String _CONTENT_TYPE_IMAGE = "image";
    private static final String _CONTENT_TYPE_TEXT = "text";
    private static final String _CONTENT_TYPE_HTML = "html";
    private static final String _CONTENT_TYPE_JAVASCRIPT = "javascript";
    private static final String _CONTENT_TYPE_JSON = "json";
    private static final String _CONTENT_TYPE_XML = "xml";
    static final Pattern patternStatusLine = Pattern.compile("(HTTP/\\d+\\.\\d+) +(\\d{3}) *([^\\x00-\\x1f\\r\\n]*)", 2);
    private static final Pattern patternPartialStatusLine = Pattern.compile("\\A *(HTTP/\\d+\\.\\d+)", 2);
    private String mStatusCodeString = "";
    private int mStatusCode = 0;
    private String mReasonPhrase = "";

    public HttpResponseHeader() {
        this.clear();
    }

    public HttpResponseHeader(String string) throws HttpMalformedHeaderException {
        this();
        this.setMessage(string);
    }

    @Override
    public void clear() {
        super.clear();
        this.mStatusCodeString = "";
        this.mStatusCode = 0;
        this.mReasonPhrase = "";
    }

    @Override
    public void setMessage(String string) throws HttpMalformedHeaderException {
        super.setMessage(string);
        try {
            this.parse();
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            this.mMalformedHeader = true;
            throw httpMalformedHeaderException;
        }
    }

    @Override
    public void setVersion(String string) {
        this.mVersion = string.toUpperCase();
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public String getReasonPhrase() {
        return this.mReasonPhrase;
    }

    private void parse() throws HttpMalformedHeaderException {
        Matcher matcher = patternStatusLine.matcher(this.mStartLine);
        if (!matcher.find()) {
            this.mMalformedHeader = true;
            throw new HttpMalformedHeaderException("Failed to find pattern: " + patternStatusLine);
        }
        this.mVersion = matcher.group(1);
        this.mStatusCodeString = matcher.group(2);
        String string = matcher.group(3);
        if (string != null) {
            this.mReasonPhrase = string;
        }
        if (!this.mVersion.equalsIgnoreCase("HTTP/1.0") && !this.mVersion.equalsIgnoreCase("HTTP/1.1")) {
            this.mMalformedHeader = true;
            throw new HttpMalformedHeaderException("Unexpected version: " + this.mVersion);
        }
        try {
            this.mStatusCode = Integer.parseInt(this.mStatusCodeString);
        }
        catch (NumberFormatException numberFormatException) {
            this.mMalformedHeader = true;
            throw new HttpMalformedHeaderException("Unexpected status code: " + this.mStatusCodeString);
        }
    }

    @Override
    public int getContentLength() {
        int n = super.getContentLength();
        if (this.mStatusCode >= 100 && this.mStatusCode < 200 || this.mStatusCode == 204 || this.mStatusCode == 304) {
            return 0;
        }
        if (this.mStatusCode >= 200 && this.mStatusCode < 300) {
            return n;
        }
        if (n > 0) {
            return n;
        }
        return 0;
    }

    public static HttpResponseHeader getError(String string) {
        HttpResponseHeader httpResponseHeader = null;
        try {
            httpResponseHeader = new HttpResponseHeader(string);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            // empty catch block
        }
        return httpResponseHeader;
    }

    @Override
    public boolean isImage() {
        String string = this.getHeader("Content-Type".toUpperCase());
        return string != null && string.toLowerCase().indexOf(_CONTENT_TYPE_IMAGE) > -1;
    }

    @Override
    public boolean isText() {
        String string = this.getHeader("Content-Type".toUpperCase());
        if (string != null) {
            if (string.toLowerCase().indexOf(_CONTENT_TYPE_TEXT) > -1) {
                return true;
            }
            if (string.toLowerCase().indexOf(_CONTENT_TYPE_HTML) > -1) {
                return true;
            }
            if (string.toLowerCase().indexOf(_CONTENT_TYPE_JAVASCRIPT) > -1) {
                return true;
            }
            if (string.toLowerCase().indexOf(_CONTENT_TYPE_JSON) > -1) {
                return true;
            }
            if (string.toLowerCase().indexOf(_CONTENT_TYPE_XML) > -1) {
                return true;
            }
        }
        return false;
    }

    public boolean isHtml() {
        String string = this.getHeader("Content-Type".toUpperCase());
        return string != null && string.toLowerCase().indexOf(_CONTENT_TYPE_HTML) > -1;
    }

    public boolean isXml() {
        String string = this.getHeader("Content-Type".toUpperCase());
        return string != null && string.toLowerCase().indexOf(_CONTENT_TYPE_XML) > -1;
    }

    public boolean isJavaScript() {
        String string = this.getHeader("Content-Type".toUpperCase());
        return string != null && string.toLowerCase().indexOf(_CONTENT_TYPE_JAVASCRIPT) > -1;
    }

    public static boolean isStatusLine(String string) {
        return patternPartialStatusLine.matcher(string).find();
    }

    @Override
    public String getPrimeHeader() {
        String string = this.getVersion() + " " + this.getStatusCode();
        if (this.getReasonPhrase() != null && !this.getReasonPhrase().equals("")) {
            string = string + " " + this.getReasonPhrase();
        }
        return string;
    }

    public List<HttpCookie> getHttpCookies(String string) {
        LinkedList<HttpCookie> linkedList = new LinkedList<HttpCookie>();
        Vector<String> vector = this.getHeaders("Set-Cookie");
        if (vector != null) {
            for (String string2 : vector) {
                linkedList.addAll(this.parseCookieString(string2, string));
            }
        }
        if ((vector = this.getHeaders("Set-Cookie2")) != null) {
            for (String string2 : vector) {
                linkedList.addAll(this.parseCookieString(string2, string));
            }
        }
        return linkedList;
    }

    private List<HttpCookie> parseCookieString(String string, String string2) {
        try {
            List<HttpCookie> list = HttpCookie.parse(string);
            if (string2 != null) {
                for (HttpCookie httpCookie : list) {
                    if (httpCookie.getDomain() != null) continue;
                    httpCookie.setDomain(string2);
                }
            }
            return list;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (string.indexOf(44) >= 0) {
                try {
                    List<HttpCookie> list = HttpCookie.parse(string.replace(',', ';'));
                    if (string2 != null) {
                        for (HttpCookie httpCookie : list) {
                            if (httpCookie.getDomain() != null) continue;
                            httpCookie.setDomain(string2);
                        }
                    }
                    return list;
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    log.error((Object)("Failed to parse cookie: " + string), (Throwable)illegalArgumentException);
                }
            }
            return new ArrayList<HttpCookie>();
        }
    }

    @Deprecated
    public List<HttpCookie> getHttpCookies() {
        return this.getHttpCookies(null);
    }

    public TreeSet<HtmlParameter> getCookieParams() {
        Object object;
        TreeSet<HtmlParameter> treeSet = new TreeSet<HtmlParameter>();
        Vector<String> vector = this.getHeaders("Set-Cookie");
        if (vector != null) {
            object = vector.iterator();
            while (object.hasNext()) {
                treeSet.add(new HtmlParameter((String)object.next()));
            }
        }
        if ((object = this.getHeaders("Set-Cookie2")) != null) {
            Iterator iterator = ((Vector)object).iterator();
            while (iterator.hasNext()) {
                treeSet.add(new HtmlParameter((String)iterator.next()));
            }
        }
        return treeSet;
    }
}

