/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.history.LogPanel;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.history.HistoryFilterPlusDialog;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.ContextCreateDialog;
import org.zaproxy.zap.view.ContextGeneralPanel;
import org.zaproxy.zap.view.ContextsTreeCellRenderer;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.SiteMapListener;
import org.zaproxy.zap.view.SiteMapTreeCellRenderer;
import org.zaproxy.zap.view.SiteTreeFilter;
import org.zaproxy.zap.view.ZapToggleButton;
import org.zaproxy.zap.view.messagecontainer.http.DefaultSelectableHistoryReferencesContainer;

public class SiteMapPanel
extends AbstractPanel {
    public static final String CONTEXT_TREE_COMPONENT_NAME = "ContextTree";
    private static final long serialVersionUID = -3161729504065679088L;
    private static Logger log = Logger.getLogger(SiteMapPanel.class);
    private JScrollPane jScrollPane = null;
    private JTree treeSite = null;
    private JTree treeContext = null;
    private DefaultTreeModel contextTree = null;
    private View view = null;
    private JToolBar panelToolbar = null;
    private ZapToggleButton scopeButton = null;
    private JButton filterButton = null;
    private JLabel filterStatus = null;
    private HistoryFilterPlusDialog filterPlusDialog = null;
    private JButton createContextButton = null;
    private JButton importContextButton = null;
    private JButton exportContextButton = null;
    private List<SiteMapListener> listeners = new ArrayList<SiteMapListener>();

    public SiteMapPanel() {
        this.initialize();
    }

    private View getView() {
        if (this.view == null) {
            this.view = View.getSingleton();
        }
        return this.view;
    }

    private void initialize() {
        this.setHideable(false);
        this.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/094.png")));
        this.setName(Constant.messages.getString("sites.panel.title"));
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1, false));
        this.setMnemonic(Constant.messages.getChar("sites.panel.mnemonic"));
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(300, 200);
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPanelToolbar(), LayoutHelper.getGBC(0, 0, 1, 0.0, new Insets(2, 2, 2, 2)));
        this.add((Component)this.getJScrollPane(), LayoutHelper.getGBC(0, 1, 1, 1.0, 1.0, 1, new Insets(2, 2, 2, 2)));
        this.expandRoot();
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName("ScriptsListToolbar");
            int n = 1;
            this.panelToolbar.add((Component)this.getScopeButton(), LayoutHelper.getGBC(n++, 0, 1, 0.0));
            this.panelToolbar.add((Component)this.getCreateContextButton(), LayoutHelper.getGBC(n++, 0, 1, 0.0));
            this.panelToolbar.add((Component)this.getImportContextButton(), LayoutHelper.getGBC(n++, 0, 1, 0.0));
            this.panelToolbar.add((Component)this.getExportContextButton(), LayoutHelper.getGBC(n++, 0, 1, 0.0));
            this.panelToolbar.add((Component)new JLabel(), LayoutHelper.getGBC(20, 0, 1, 1.0));
        }
        return this.panelToolbar;
    }

    private HistoryFilterPlusDialog getFilterPlusDialog() {
        if (this.filterPlusDialog == null) {
            this.filterPlusDialog = new HistoryFilterPlusDialog((Frame)this.getView().getMainFrame(), true);
            this.filterPlusDialog.setTitle(Constant.messages.getString("sites.filter.title"));
        }
        return this.filterPlusDialog;
    }

    private JLabel getFilterStatus() {
        this.filterStatus = new JLabel(Constant.messages.getString("history.filter.label.filter") + Constant.messages.getString("history.filter.label.off"));
        return this.filterStatus;
    }

    private JButton getFilterButton() {
        if (this.filterButton == null) {
            this.filterButton = new JButton();
            this.filterButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/16/054.png"))));
            this.filterButton.setToolTipText(Constant.messages.getString("history.filter.button.filter"));
            this.filterButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SiteMapPanel.this.showFilterPlusDialog();
                }
            });
        }
        return this.filterButton;
    }

    private JButton getCreateContextButton() {
        if (this.createContextButton == null) {
            this.createContextButton = new JButton();
            this.createContextButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/fugue/application-blue-plus.png"))));
            this.createContextButton.setToolTipText(Constant.messages.getString("menu.file.context.create"));
            this.createContextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ContextCreateDialog contextCreateDialog = new ContextCreateDialog(View.getSingleton().getMainFrame());
                    contextCreateDialog.setVisible(true);
                }
            });
        }
        return this.createContextButton;
    }

    private JButton getImportContextButton() {
        if (this.importContextButton == null) {
            this.importContextButton = new JButton();
            this.importContextButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/fugue/application-blue-import.png"))));
            this.importContextButton.setToolTipText(Constant.messages.getString("menu.file.context.import"));
            this.importContextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Control.getSingleton().getMenuFileControl().importContext();
                }
            });
        }
        return this.importContextButton;
    }

    private JButton getExportContextButton() {
        if (this.exportContextButton == null) {
            this.exportContextButton = new JButton();
            this.exportContextButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(LogPanel.class.getResource("/resource/icon/fugue/application-blue-export.png"))));
            this.exportContextButton.setToolTipText(Constant.messages.getString("menu.file.context.export"));
            this.exportContextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Control.getSingleton().getMenuFileControl().exportContext();
                }
            });
        }
        return this.exportContextButton;
    }

    private void showFilterPlusDialog() {
        HistoryFilterPlusDialog historyFilterPlusDialog = this.getFilterPlusDialog();
        historyFilterPlusDialog.setModal(true);
        try {
            historyFilterPlusDialog.setAllTags(Model.getSingleton().getDb().getTableTag().getAllTags());
        }
        catch (DatabaseException databaseException) {
            log.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
        int n = historyFilterPlusDialog.showDialog();
        SiteTreeFilter siteTreeFilter = new SiteTreeFilter(historyFilterPlusDialog.getFilter());
        siteTreeFilter.setInScope(this.getScopeButton().isSelected());
        if (n != 2) {
            this.setFilter();
        }
    }

    private void setFilter() {
        SiteTreeFilter siteTreeFilter = new SiteTreeFilter(this.getFilterPlusDialog().getFilter());
        siteTreeFilter.setInScope(this.scopeButton.isSelected());
        ((SiteMap)this.treeSite.getModel()).setFilter(siteTreeFilter);
        ((DefaultTreeModel)this.treeSite.getModel()).nodeStructureChanged((SiteNode)this.treeSite.getModel().getRoot());
        this.getFilterStatus().setText(siteTreeFilter.toShortString());
        this.getFilterStatus().setToolTipText(siteTreeFilter.toLongString());
        this.expandRoot();
        this.reloadContextTree();
    }

    private JToggleButton getScopeButton() {
        if (this.scopeButton == null) {
            this.scopeButton = new ZapToggleButton();
            this.scopeButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(SiteMapPanel.class.getResource("/resource/icon/fugue/target-grey.png"))));
            this.scopeButton.setToolTipText(Constant.messages.getString("history.scope.button.unselected"));
            this.scopeButton.setSelectedIcon(DisplayUtils.getScaledIcon(new ImageIcon(SiteMapPanel.class.getResource("/resource/icon/fugue/target.png"))));
            this.scopeButton.setSelectedToolTipText(Constant.messages.getString("history.scope.button.selected"));
            this.scopeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SiteMapPanel.this.setFilter();
                }
            });
        }
        return this.scopeButton;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(200, 400));
            this.jScrollPane.setName("sitesPanelScrollPane");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)this.getTreeContext(), LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0));
            jPanel.add((Component)this.getTreeSite(), LayoutHelper.getGBC(0, 1, 1, 1.0, 1.0));
            this.jScrollPane.setViewportView(jPanel);
        }
        return this.jScrollPane;
    }

    public JTree getTreeSite() {
        if (this.treeSite == null) {
            this.treeSite = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode()));
            this.treeSite.setShowsRootHandles(true);
            this.treeSite.setName("treeSite");
            this.treeSite.setToggleClickCount(1);
            this.treeSite.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    SiteNode siteNode = (SiteNode)SiteMapPanel.this.treeSite.getLastSelectedPathComponent();
                    if (siteNode == null) {
                        return;
                    }
                    if (!siteNode.isRoot()) {
                        HttpMessage httpMessage = null;
                        try {
                            httpMessage = siteNode.getHistoryReference().getHttpMessage();
                        }
                        catch (Exception exception) {
                            log.warn((Object)exception.getMessage(), (Throwable)exception);
                            return;
                        }
                        SiteMapPanel.this.getView().displayMessage(httpMessage);
                        for (SiteMapListener siteMapListener : SiteMapPanel.this.listeners) {
                            siteMapListener.nodeSelected(siteNode);
                        }
                    } else {
                        SiteMapPanel.this.getView().displayMessage(null);
                    }
                }
            });
            this.treeSite.setComponentPopupMenu(new SitesCustomPopupMenu());
            SiteMapTreeCellRenderer siteMapTreeCellRenderer = new SiteMapTreeCellRenderer(this.listeners);
            this.treeSite.setCellRenderer(siteMapTreeCellRenderer);
        }
        return this.treeSite;
    }

    public void reloadContextTree() {
        SiteNode siteNode;
        if (this.contextTree == null) {
            siteNode = new SiteNode(null, -1, Constant.messages.getString("context.list"));
            this.contextTree = new DefaultTreeModel(siteNode);
        } else {
            siteNode = (SiteNode)this.contextTree.getRoot();
            siteNode.removeAllChildren();
        }
        for (Context context : Model.getSingleton().getSession().getContexts()) {
            if (!context.isInScope() && this.getScopeButton().isSelected()) continue;
            SiteNode siteNode2 = new SiteNode(null, 1, context.getName());
            siteNode2.setUserObject(new Target(context));
            siteNode.add(siteNode2);
        }
        this.contextTree.nodeStructureChanged(siteNode);
    }

    private JTree getTreeContext() {
        if (this.treeContext == null) {
            this.reloadContextTree();
            this.treeContext = new JTree(this.contextTree);
            this.treeContext.setShowsRootHandles(true);
            this.treeContext.setName(CONTEXT_TREE_COMPONENT_NAME);
            this.treeContext.setToggleClickCount(1);
            this.treeContext.getSelectionModel().setSelectionMode(1);
            this.treeContext.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.mouseClicked(mouseEvent);
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    SiteNode siteNode;
                    if (SiteMapPanel.this.treeSite.getLastSelectedPathComponent() != null) {
                        SiteMapPanel.this.getTreeSite().clearSelection();
                    }
                    if (mouseEvent.getClickCount() > 1 && (siteNode = (SiteNode)SiteMapPanel.this.treeContext.getLastSelectedPathComponent()) != null && siteNode.getUserObject() != null) {
                        Target target = (Target)siteNode.getUserObject();
                        SiteMapPanel.this.getView().showSessionDialog(Model.getSingleton().getSession(), ContextGeneralPanel.getPanelName(target.getContext()));
                    }
                }
            });
            this.treeContext.setComponentPopupMenu(new ContextsCustomPopupMenu());
            this.treeContext.setCellRenderer(new ContextsTreeCellRenderer());
        }
        return this.treeContext;
    }

    public void expandRoot() {
        TreeNode treeNode = (TreeNode)this.treeSite.getModel().getRoot();
        if (treeNode == null) {
            return;
        }
        final TreePath treePath = new TreePath(treeNode);
        if (EventQueue.isDispatchThread()) {
            this.getTreeSite().expandPath(treePath);
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SiteMapPanel.this.getTreeSite().expandPath(treePath);
                }
            });
        }
        catch (Exception exception) {
            log.warn((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public void addSiteMapListener(SiteMapListener siteMapListener) {
        this.listeners.add(siteMapListener);
    }

    public void removeSiteMapListener(SiteMapListener siteMapListener) {
        this.listeners.remove(siteMapListener);
    }

    public void showInSites(SiteNode siteNode) {
        Object[] objectArray = siteNode.getPath();
        TreePath treePath = new TreePath(objectArray);
        this.treeSite.setExpandsSelectedPaths(true);
        this.treeSite.setSelectionPath(treePath);
        this.treeSite.scrollPathToVisible(treePath);
    }

    public void contextChanged(Context context) {
        this.getTreeContext();
        SiteNode siteNode = (SiteNode)this.contextTree.getRoot();
        for (int i = 0; i < siteNode.getChildCount(); ++i) {
            SiteNode siteNode2 = (SiteNode)siteNode.getChildAt(i);
            Target target = (Target)siteNode2.getUserObject();
            if (context.getIndex() != target.getContext().getIndex()) continue;
            target.setContext(context);
            if (siteNode2.getNodeName().equals(context.getName())) {
                this.contextTree.nodeChanged(siteNode2);
                break;
            }
            this.reloadContextTree();
            break;
        }
    }

    protected class ContextsCustomPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        protected ContextsCustomPopupMenu() {
        }

        @Override
        public void show(Component component, int n, int n2) {
            TreePath treePath = SiteMapPanel.this.treeContext.getPathForLocation(n, n2);
            if (treePath != null) {
                boolean bl = true;
                if (SiteMapPanel.this.treeContext.getSelectionPaths() != null) {
                    for (TreePath treePath2 : SiteMapPanel.this.treeContext.getSelectionPaths()) {
                        if (!treePath2.equals(treePath)) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    SiteMapPanel.this.treeContext.getSelectionModel().setSelectionPath(treePath);
                }
            }
            View.getSingleton().getPopupMenu().show(SiteMapPanel.this.treeContext, n, n2);
        }
    }

    protected class SitesCustomPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        protected SitesCustomPopupMenu() {
        }

        @Override
        public void show(Component component, int n, int n2) {
            int n3;
            TreePath treePath = SiteMapPanel.this.treeSite.getPathForLocation(n, n2);
            if (treePath != null) {
                n3 = 1;
                if (SiteMapPanel.this.treeSite.getSelectionPaths() != null) {
                    for (TreePath treePath2 : SiteMapPanel.this.treeSite.getSelectionPaths()) {
                        if (!treePath2.equals(treePath)) continue;
                        n3 = 0;
                        break;
                    }
                }
                if (n3 != 0) {
                    SiteMapPanel.this.treeSite.getSelectionModel().setSelectionPath(treePath);
                }
            }
            n3 = SiteMapPanel.this.treeSite.getSelectionCount();
            TreePath[] treePathArray = new ArrayList(n3);
            if (n3 > 0) {
                for (TreePath treePath3 : SiteMapPanel.this.treeSite.getSelectionPaths()) {
                    SiteNode siteNode = (SiteNode)treePath3.getLastPathComponent();
                    HistoryReference historyReference = siteNode.getHistoryReference();
                    if (historyReference == null) continue;
                    treePathArray.add(historyReference);
                }
            }
            DefaultSelectableHistoryReferencesContainer defaultSelectableHistoryReferencesContainer = new DefaultSelectableHistoryReferencesContainer(SiteMapPanel.this.treeSite.getName(), SiteMapPanel.this.treeSite, Collections.emptyList(), (List<HistoryReference>)treePathArray);
            View.getSingleton().getPopupMenu().show(defaultSelectableHistoryReferencesContainer, n, n2);
        }
    }
}

