/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.AlreadyExpiredException;
import org.elasticsearch.index.analysis.NumericLongAnalyzer;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.internal.EnabledAttributeMapper;
import org.elasticsearch.search.internal.SearchContext;

public class TTLFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_ttl";
    public static final String CONTENT_TYPE = "_ttl";
    private EnabledAttributeMapper enabledState;
    private long defaultTTL;

    private TTLFieldMapper(Settings indexSettings) {
        this(Defaults.TTL_FIELD_TYPE.clone(), Defaults.ENABLED_STATE, -1L, null, indexSettings);
    }

    private TTLFieldMapper(MappedFieldType fieldType, EnabledAttributeMapper enabled, long defaultTTL, @Nullable Settings fieldDataSettings, Settings indexSettings) {
        super("_ttl", fieldType, Defaults.TTL_FIELD_TYPE, indexSettings);
        this.enabledState = enabled;
        this.defaultTTL = defaultTTL;
    }

    public boolean enabled() {
        return this.enabledState.enabled;
    }

    public long defaultTTL() {
        return this.defaultTTL;
    }

    public Object valueForSearch(long expirationTime) {
        return expirationTime - System.currentTimeMillis();
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException, MapperParsingException {
        if (context.sourceToParse().ttl() < 0L) {
            long ttl = context.parser().currentToken() == XContentParser.Token.VALUE_STRING ? TimeValue.parseTimeValue(context.parser().text(), null, "ttl").millis() : context.parser().longValue(true);
            if (ttl <= 0L) {
                throw new MapperParsingException("TTL value must be > 0. Illegal value provided [" + ttl + "]");
            }
            context.sourceToParse().ttl(ttl);
        }
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException, AlreadyExpiredException {
        if (this.enabledState.enabled && !context.sourceToParse().flyweight()) {
            long ttl = context.sourceToParse().ttl();
            if (ttl <= 0L && this.defaultTTL > 0L) {
                ttl = this.defaultTTL;
                context.sourceToParse().ttl(ttl);
            }
            if (ttl > 0L) {
                long timestamp = context.sourceToParse().timestamp();
                long expire = new Date(timestamp + ttl).getTime();
                long now = System.currentTimeMillis();
                if (context.sourceToParse().origin() == SourceToParse.Origin.PRIMARY && now >= expire) {
                    throw new AlreadyExpiredException(context.index(), context.type(), context.id(), timestamp, ttl, now);
                }
                fields.add(new LongFieldMapper.CustomLongNumericField(expire, this.fieldType()));
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.enabledState == Defaults.ENABLED_STATE && this.defaultTTL == -1L) {
            return builder;
        }
        builder.startObject("_ttl");
        if (includeDefaults || this.enabledState != Defaults.ENABLED_STATE) {
            builder.field("enabled", this.enabledState.enabled);
        }
        if (includeDefaults || this.defaultTTL != -1L && this.enabledState.enabled) {
            builder.field("default", this.defaultTTL);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected String contentType() {
        return "_ttl";
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        TTLFieldMapper ttlMergeWith = (TTLFieldMapper)mergeWith;
        if (ttlMergeWith.enabledState != Defaults.ENABLED_STATE) {
            if (this.enabledState == EnabledAttributeMapper.ENABLED && ttlMergeWith.enabledState == EnabledAttributeMapper.DISABLED) {
                throw new IllegalArgumentException("_ttl cannot be disabled once it was enabled.");
            }
            this.enabledState = ttlMergeWith.enabledState;
        }
        if (ttlMergeWith.defaultTTL != -1L && this.enabledState == EnabledAttributeMapper.ENABLED) {
            this.defaultTTL = ttlMergeWith.defaultTTL;
        }
    }

    public static final class TTLFieldType
    extends LongFieldMapper.LongFieldType {
        public TTLFieldType() {
        }

        protected TTLFieldType(TTLFieldType ref) {
            super(ref);
        }

        @Override
        public TTLFieldType clone() {
            return new TTLFieldType(this);
        }

        @Override
        public Object valueForSearch(Object value) {
            SearchContext searchContext = SearchContext.current();
            long now = searchContext != null ? searchContext.nowInMillis() : System.currentTimeMillis();
            long val = this.value(value);
            return val - now;
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder();
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    EnabledAttributeMapper enabledState = XContentMapValues.nodeBooleanValue(fieldNode) ? EnabledAttributeMapper.ENABLED : EnabledAttributeMapper.DISABLED;
                    builder.enabled(enabledState);
                    iterator.remove();
                    continue;
                }
                if (!fieldName.equals("default")) continue;
                TimeValue ttlTimeValue = XContentMapValues.nodeTimeValue(fieldNode, null);
                if (ttlTimeValue != null) {
                    builder.defaultTTL(ttlTimeValue.millis());
                }
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(Settings indexSettings, MappedFieldType fieldType, String typeName) {
            return new TTLFieldMapper(indexSettings);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, TTLFieldMapper> {
        private EnabledAttributeMapper enabledState = EnabledAttributeMapper.UNSET_DISABLED;
        private long defaultTTL = -1L;

        public Builder() {
            super("_ttl", Defaults.TTL_FIELD_TYPE, Defaults.FIELD_TYPE);
        }

        public Builder enabled(EnabledAttributeMapper enabled) {
            this.enabledState = enabled;
            return (Builder)this.builder;
        }

        public Builder defaultTTL(long defaultTTL) {
            this.defaultTTL = defaultTTL;
            return (Builder)this.builder;
        }

        @Override
        public TTLFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            this.fieldType.setHasDocValues(false);
            return new TTLFieldMapper(this.fieldType, this.enabledState, this.defaultTTL, this.fieldDataSettings, context.indexSettings());
        }
    }

    public static class Defaults
    extends LongFieldMapper.Defaults {
        public static final String NAME = "_ttl";
        public static final TTLFieldType TTL_FIELD_TYPE = new TTLFieldType();
        public static final EnabledAttributeMapper ENABLED_STATE;
        public static final long DEFAULT = -1L;

        static {
            TTL_FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            TTL_FIELD_TYPE.setStored(true);
            TTL_FIELD_TYPE.setTokenized(false);
            TTL_FIELD_TYPE.setNumericPrecisionStep(16);
            TTL_FIELD_TYPE.setIndexAnalyzer(NumericLongAnalyzer.buildNamedAnalyzer(16));
            TTL_FIELD_TYPE.setSearchAnalyzer(NumericLongAnalyzer.buildNamedAnalyzer(Integer.MAX_VALUE));
            TTL_FIELD_TYPE.setNames(new MappedFieldType.Names("_ttl"));
            TTL_FIELD_TYPE.freeze();
            ENABLED_STATE = EnabledAttributeMapper.UNSET_DISABLED;
        }
    }
}

