/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.metrics.ValuesSourceMetricsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.AbstractPercentilesParser;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesMethod;

abstract class AbstractPercentilesBuilder<PB extends AbstractPercentilesBuilder<PB>>
extends ValuesSourceMetricsAggregationBuilder<PB> {
    private Double compression;
    private PercentilesMethod method;
    private Integer numberOfSignificantValueDigits;

    public AbstractPercentilesBuilder(String name, String type) {
        super(name, type);
    }

    public PB method(PercentilesMethod method) {
        this.method = method;
        return (PB)this;
    }

    public PB compression(double compression) {
        this.compression = compression;
        return (PB)this;
    }

    public PB numberOfSignificantValueDigits(int numberOfSignificantValueDigits) {
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        return (PB)this;
    }

    @Override
    protected void internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.internalXContent(builder, params);
        this.doInternalXContent(builder, params);
        if (this.method != null) {
            builder.startObject(this.method.getName());
            if (this.compression != null) {
                builder.field(AbstractPercentilesParser.COMPRESSION_FIELD.getPreferredName(), this.compression);
            }
            if (this.numberOfSignificantValueDigits != null) {
                builder.field(AbstractPercentilesParser.NUMBER_SIGNIFICANT_DIGITS_FIELD.getPreferredName(), this.numberOfSignificantValueDigits);
            }
            builder.endObject();
        }
    }

    protected abstract void doInternalXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;
}

