/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.UnitType;

public class AbstractUnit
extends FreeColObject {
    private String roleId = "model.role.default";
    private int number = 1;
    private static final String ROLE_TAG = "role";
    private static final String NUMBER_TAG = "number";

    public AbstractUnit() {
    }

    public AbstractUnit(String id, String roleId, int number) {
        this.setId(id);
        this.roleId = roleId;
        this.number = number;
    }

    public AbstractUnit(UnitType unitType, String roleId, int number) {
        this(unitType.getId(), roleId, number);
    }

    public AbstractUnit(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public final String getRoleId() {
        return this.roleId;
    }

    public final void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public final int getNumber() {
        return this.number;
    }

    public final void setNumber(int newNumber) {
        this.number = newNumber;
    }

    public StringTemplate getLabel() {
        StringTemplate tmpl = Messages.getUnitLabel(null, this.getId(), this.getNumber(), null, this.getRoleId(), null);
        return StringTemplate.template("model.abstractUnit.label").addAmount("%number%", this.getNumber()).addStringTemplate("%unit%", tmpl);
    }

    public String getDescription() {
        return Messages.message(this.getLabel());
    }

    public Role getRole(Specification spec) {
        return spec.getRole(this.getRoleId());
    }

    public UnitType getType(Specification spec) {
        return spec.getUnitType(this.getId());
    }

    public double getOffence(Specification spec) {
        int n = this.getNumber();
        Role role = this.getRole(spec);
        UnitType type = spec.getUnitType(this.getId());
        return (double)n * (type.getOffence() + role.getOffence());
    }

    public static double calculateStrength(Specification spec, List<AbstractUnit> units) {
        return units.stream().mapToDouble(au -> au.getOffence(spec)).sum();
    }

    public static List<AbstractUnit> deepCopy(List<AbstractUnit> units) {
        ArrayList<AbstractUnit> result = new ArrayList<AbstractUnit>();
        for (AbstractUnit au : units) {
            result.add(new AbstractUnit(au.getId(), au.getRoleId(), au.getNumber()));
        }
        return result;
    }

    public static StringTemplate getListLabel(String base, List<AbstractUnit> units) {
        StringTemplate template = StringTemplate.label(base);
        for (AbstractUnit au : units) {
            template.addStringTemplate(au.getLabel());
        }
        return template;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(ROLE_TAG, this.roleId);
        xw.writeAttribute(NUMBER_TAG, this.number);
    }

    @Override
    protected final void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.roleId = xr.getAttribute(ROLE_TAG, "model.role.default");
        this.roleId = Role.fixRoleId(this.roleId);
        this.number = xr.getAttribute(NUMBER_TAG, 1);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append(this.number).append(" ").append(this.getId()).append(" (").append(this.roleId).append(")");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return AbstractUnit.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "abstractUnit";
    }
}

