/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl.glu.gl2es1;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.ReflectionUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.media.opengl.GL2ES1;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;
import jogamp.opengl.glu.mipmap.Mipmap;

public class GLUgl2es1
extends GLU {
    protected static boolean availableMipmap = false;
    protected static boolean checkedMipmap = false;

    @Override
    public void destroy() {
        super.destroy();
    }

    public static final GL2ES1 getCurrentGL2ES1() throws GLException {
        GLContext gLContext = GLContext.getCurrent();
        if (gLContext == null) {
            throw new GLException("No OpenGL context current on this thread");
        }
        return gLContext.getGL().getGL2ES1();
    }

    protected static final void validateMipmap() {
        if (!checkedMipmap) {
            availableMipmap = ReflectionUtil.isClassAvailable((String)"jogamp.opengl.glu.mipmap.Mipmap", (ClassLoader)GLU.class.getClassLoader());
            checkedMipmap = true;
        }
        if (!availableMipmap) {
            throw new GLException("Mipmap not available");
        }
    }

    private final ByteBuffer copyToByteBuffer(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            if (buffer.position() == 0) {
                return (ByteBuffer)buffer;
            }
            return Buffers.copyByteBuffer((ByteBuffer)((ByteBuffer)buffer));
        }
        if (buffer instanceof ShortBuffer) {
            return Buffers.copyShortBufferAsByteBuffer((ShortBuffer)((ShortBuffer)buffer));
        }
        if (buffer instanceof IntBuffer) {
            return Buffers.copyIntBufferAsByteBuffer((IntBuffer)((IntBuffer)buffer));
        }
        if (buffer instanceof FloatBuffer) {
            return Buffers.copyFloatBufferAsByteBuffer((FloatBuffer)((FloatBuffer)buffer));
        }
        throw new IllegalArgumentException("Unsupported buffer type (must be one of byte, short, int, or float)");
    }

    @Override
    public final int gluScaleImage(int n, int n2, int n3, int n4, Buffer buffer, int n5, int n6, int n7, Buffer buffer2) {
        GLUgl2es1.validateMipmap();
        ByteBuffer byteBuffer = null;
        ByteBuffer byteBuffer2 = null;
        byteBuffer = this.copyToByteBuffer(buffer);
        if (buffer2 instanceof ByteBuffer) {
            byteBuffer2 = (ByteBuffer)buffer2;
        } else if (buffer2 instanceof ShortBuffer) {
            byteBuffer2 = Buffers.newDirectByteBuffer((int)(buffer2.remaining() * 2));
        } else if (buffer2 instanceof IntBuffer) {
            byteBuffer2 = Buffers.newDirectByteBuffer((int)(buffer2.remaining() * 4));
        } else if (buffer2 instanceof FloatBuffer) {
            byteBuffer2 = Buffers.newDirectByteBuffer((int)(buffer2.remaining() * 4));
        } else {
            throw new IllegalArgumentException("Unsupported destination buffer type (must be byte, short, int, or float)");
        }
        int n8 = Mipmap.gluScaleImage(GLUgl2es1.getCurrentGL2ES1(), n, n2, n3, n4, byteBuffer, n5, n6, n7, byteBuffer2);
        if (n8 == 0) {
            byteBuffer2.rewind();
            if (byteBuffer2 != buffer2) {
                if (buffer2 instanceof ShortBuffer) {
                    ((ShortBuffer)buffer2).put(byteBuffer2.asShortBuffer());
                } else if (buffer2 instanceof IntBuffer) {
                    ((IntBuffer)buffer2).put(byteBuffer2.asIntBuffer());
                } else if (buffer2 instanceof FloatBuffer) {
                    ((FloatBuffer)buffer2).put(byteBuffer2.asFloatBuffer());
                } else {
                    throw new RuntimeException("Should not reach here");
                }
            }
        }
        return n8;
    }

    @Override
    public final int gluBuild1DMipmapLevels(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        GLUgl2es1.validateMipmap();
        ByteBuffer byteBuffer = this.copyToByteBuffer(buffer);
        return Mipmap.gluBuild1DMipmapLevels(GLUgl2es1.getCurrentGL2ES1(), n, n2, n3, n4, n5, n6, n7, n8, byteBuffer);
    }

    @Override
    public final int gluBuild1DMipmaps(int n, int n2, int n3, int n4, int n5, Buffer buffer) {
        GLUgl2es1.validateMipmap();
        ByteBuffer byteBuffer = this.copyToByteBuffer(buffer);
        return Mipmap.gluBuild1DMipmaps(GLUgl2es1.getCurrentGL2ES1(), n, n2, n3, n4, n5, byteBuffer);
    }

    @Override
    public final int gluBuild2DMipmapLevels(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer) {
        GLUgl2es1.validateMipmap();
        buffer = this.copyToByteBuffer(buffer);
        return Mipmap.gluBuild2DMipmapLevels(GLUgl2es1.getCurrentGL2ES1(), n, n2, n3, n4, n5, n6, n7, n8, n9, buffer);
    }

    @Override
    public final int gluBuild2DMipmaps(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        GLUgl2es1.validateMipmap();
        buffer = this.copyToByteBuffer(buffer);
        return Mipmap.gluBuild2DMipmaps(GLUgl2es1.getCurrentGL2ES1(), n, n2, n3, n4, n5, n6, buffer);
    }

    @Override
    public final int gluBuild3DMipmapLevels(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Buffer buffer) {
        GLUgl2es1.validateMipmap();
        ByteBuffer byteBuffer = this.copyToByteBuffer(buffer);
        return Mipmap.gluBuild3DMipmapLevels(GLUgl2es1.getCurrentGL2ES1(), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, byteBuffer);
    }

    @Override
    public final int gluBuild3DMipmaps(int n, int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        GLUgl2es1.validateMipmap();
        ByteBuffer byteBuffer = this.copyToByteBuffer(buffer);
        return Mipmap.gluBuild3DMipmaps(GLUgl2es1.getCurrentGL2ES1(), n, n2, n3, n4, n5, n6, n7, byteBuffer);
    }
}

