/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.hub;

import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import org.gradle.messaging.remote.internal.hub.IncomingQueue;
import org.gradle.messaging.remote.internal.hub.protocol.ChannelMessage;
import org.gradle.messaging.remote.internal.hub.protocol.EndOfStream;
import org.gradle.messaging.remote.internal.hub.protocol.InterHubMessage;
import org.gradle.messaging.remote.internal.hub.protocol.RejectedMessage;
import org.gradle.messaging.remote.internal.hub.queue.MultiEndPointQueue;

class OutgoingQueue
extends MultiEndPointQueue {
    private final IncomingQueue incomingQueue;

    OutgoingQueue(IncomingQueue incomingQueue, Lock lock) {
        super(lock);
        this.incomingQueue = incomingQueue;
    }

    void endOutput() {
        this.dispatch(new EndOfStream());
    }

    void discardQueued() {
        ArrayList<InterHubMessage> rejected = new ArrayList<InterHubMessage>();
        this.drain(rejected);
        for (InterHubMessage message : rejected) {
            if (!(message instanceof ChannelMessage)) continue;
            ChannelMessage channelMessage = (ChannelMessage)message;
            this.incomingQueue.queue(new RejectedMessage(channelMessage.getChannel(), channelMessage.getPayload()));
        }
    }
}

