/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.server.DaemonServerConnector;
import org.gradle.launcher.daemon.server.DaemonStateCoordinator;
import org.gradle.launcher.daemon.server.DefaultIncomingConnectionHandler;
import org.gradle.launcher.daemon.server.DomainRegistryUpdater;
import org.gradle.launcher.daemon.server.exec.DaemonCommandExecuter;
import org.gradle.messaging.remote.Address;

public class Daemon
implements Stoppable {
    private static final Logger LOGGER = Logging.getLogger(Daemon.class);
    private final DaemonServerConnector connector;
    private final DaemonRegistry daemonRegistry;
    private final DaemonContext daemonContext;
    private final DaemonCommandExecuter commandExecuter;
    private final ExecutorFactory executorFactory;
    private final String password;
    private DaemonStateCoordinator stateCoordinator;
    private final Lock lifecyleLock = new ReentrantLock();
    private Address connectorAddress;
    private DomainRegistryUpdater registryUpdater;
    private DefaultIncomingConnectionHandler connectionHandler;

    public Daemon(DaemonServerConnector connector, DaemonRegistry daemonRegistry, DaemonContext daemonContext, String password, DaemonCommandExecuter commandExecuter, ExecutorFactory executorFactory) {
        this.connector = connector;
        this.daemonRegistry = daemonRegistry;
        this.daemonContext = daemonContext;
        this.password = password;
        this.commandExecuter = commandExecuter;
        this.executorFactory = executorFactory;
    }

    public String getUid() {
        return this.daemonContext.getUid();
    }

    public Address getAddress() {
        return this.connectorAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LOGGER.info("start() called on daemon - {}", this.daemonContext);
        this.lifecyleLock.lock();
        try {
            if (this.stateCoordinator != null) {
                throw new IllegalStateException("cannot start daemon as it is already running");
            }
            this.registryUpdater = new DomainRegistryUpdater(this.daemonRegistry, this.daemonContext, this.password);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        Daemon.this.daemonRegistry.remove(Daemon.this.connectorAddress);
                    }
                    catch (Exception e) {
                        LOGGER.debug("VM shutdown hook was unable to remove the daemon address from the registry. It will be cleaned up later.", e);
                    }
                }
            });
            Runnable onStartCommand = new Runnable(){

                public void run() {
                    Daemon.this.registryUpdater.onStartActivity();
                }
            };
            Runnable onFinishCommand = new Runnable(){

                public void run() {
                    Daemon.this.registryUpdater.onCompleteActivity();
                }
            };
            this.stateCoordinator = new DaemonStateCoordinator(this.executorFactory, onStartCommand, onFinishCommand);
            this.connectionHandler = new DefaultIncomingConnectionHandler(this.commandExecuter, this.daemonContext, this.stateCoordinator, this.executorFactory);
            Runnable connectionErrorHandler = new Runnable(){

                public void run() {
                    Daemon.this.stateCoordinator.stop();
                }
            };
            this.connectorAddress = this.connector.start(this.connectionHandler, connectionErrorHandler);
            LOGGER.debug("Daemon starting at: {}, with address: {}", new Date(), this.connectorAddress);
            this.registryUpdater.onStart(this.connectorAddress);
        }
        finally {
            this.lifecyleLock.unlock();
        }
        LOGGER.lifecycle("Daemon server started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOGGER.debug("stop() called on daemon");
        this.lifecyleLock.lock();
        try {
            if (this.stateCoordinator == null) {
                throw new IllegalStateException("cannot stop daemon as it has not been started.");
            }
            LOGGER.info("Stop requested. Daemon is removing its presence from the registry...");
            CompositeStoppable.stoppable(this.stateCoordinator, this.registryUpdater, this.connector, this.connectionHandler).stop();
        }
        finally {
            this.lifecyleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStopOnIdleTimeout(int idleTimeout, TimeUnit idleTimeoutUnits) {
        DaemonStateCoordinator stateCoordinator;
        LOGGER.debug("requestStopOnIdleTimeout({} {}) called on daemon", idleTimeout, (Object)idleTimeoutUnits);
        this.lifecyleLock.lock();
        try {
            if (this.stateCoordinator == null) {
                throw new IllegalStateException("cannot stop daemon as it has not been started.");
            }
            stateCoordinator = this.stateCoordinator;
        }
        finally {
            this.lifecyleLock.unlock();
        }
        stateCoordinator.stopOnIdleTimeout(idleTimeout, idleTimeoutUnits);
    }
}

