/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cfg.context.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.cfg.context.impl.ConfiguredConstraint;
import org.hibernate.validator.group.DefaultGroupSequenceProvider;
import org.hibernate.validator.metadata.location.BeanConstraintLocation;
import org.hibernate.validator.metadata.location.MethodConstraintLocation;
import org.hibernate.validator.util.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintMappingContext {
    private final Map<Class<?>, List<ConfiguredConstraint<?, BeanConstraintLocation>>> constraintConfig = CollectionHelper.newHashMap();
    private final Map<Class<?>, List<ConfiguredConstraint<?, MethodConstraintLocation>>> methodConstraintConfig = CollectionHelper.newHashMap();
    private final Map<Class<?>, List<BeanConstraintLocation>> cascadeConfig = CollectionHelper.newHashMap();
    private final Map<Class<?>, List<MethodConstraintLocation>> methodCascadeConfig = CollectionHelper.newHashMap();
    private final Set<Class<?>> configuredClasses = CollectionHelper.newHashSet();
    private final Map<Class<?>, List<Class<?>>> defaultGroupSequences = CollectionHelper.newHashMap();
    private final Map<Class<?>, Class<? extends DefaultGroupSequenceProvider<?>>> defaultGroupSequenceProviders = CollectionHelper.newHashMap();

    public static ConstraintMappingContext getFromMapping(ConstraintMapping mapping) {
        return new ConstraintMappingContextAccessor(mapping).getContext();
    }

    public final Map<Class<?>, List<ConfiguredConstraint<?, BeanConstraintLocation>>> getConstraintConfig() {
        return this.constraintConfig;
    }

    public Map<Class<?>, List<ConfiguredConstraint<?, MethodConstraintLocation>>> getMethodConstraintConfig() {
        return this.methodConstraintConfig;
    }

    public final Map<Class<?>, List<BeanConstraintLocation>> getCascadeConfig() {
        return this.cascadeConfig;
    }

    public final Map<Class<?>, List<MethodConstraintLocation>> getMethodCascadeConfig() {
        return this.methodCascadeConfig;
    }

    public final Collection<Class<?>> getConfiguredClasses() {
        return this.configuredClasses;
    }

    public final List<Class<?>> getDefaultSequence(Class<?> beanType) {
        if (this.defaultGroupSequences.containsKey(beanType)) {
            return this.defaultGroupSequences.get(beanType);
        }
        return Collections.emptyList();
    }

    public final Class<? extends DefaultGroupSequenceProvider<?>> getDefaultGroupSequenceProvider(Class<?> beanType) {
        return this.defaultGroupSequenceProviders.get(beanType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConstraintMapping");
        sb.append("{cascadeConfig=").append(this.cascadeConfig);
        sb.append(", methodCascadeConfig=").append(this.methodCascadeConfig);
        sb.append(", constraintConfig=").append(this.constraintConfig);
        sb.append(", configuredClasses=").append(this.configuredClasses);
        sb.append(", defaultGroupSequences=").append(this.defaultGroupSequences);
        sb.append('}');
        return sb.toString();
    }

    public final void addCascadeConfig(BeanConstraintLocation cascade) {
        Class<?> beanClass = cascade.getBeanClass();
        this.configuredClasses.add(beanClass);
        if (this.cascadeConfig.containsKey(beanClass)) {
            this.cascadeConfig.get(beanClass).add(cascade);
        } else {
            ArrayList cascadeList = CollectionHelper.newArrayList();
            cascadeList.add(cascade);
            this.cascadeConfig.put(beanClass, cascadeList);
        }
    }

    public final void addMethodCascadeConfig(MethodConstraintLocation cascade) {
        Class<?> beanClass = cascade.getBeanClass();
        this.configuredClasses.add(beanClass);
        if (this.methodCascadeConfig.containsKey(beanClass)) {
            this.methodCascadeConfig.get(beanClass).add(cascade);
        } else {
            ArrayList cascadeList = CollectionHelper.newArrayList();
            cascadeList.add(cascade);
            this.methodCascadeConfig.put(beanClass, cascadeList);
        }
    }

    public final void addDefaultGroupSequence(Class<?> beanClass, List<Class<?>> defaultGroupSequence) {
        this.configuredClasses.add(beanClass);
        this.defaultGroupSequences.put(beanClass, defaultGroupSequence);
    }

    public final <T extends DefaultGroupSequenceProvider<?>> void addDefaultGroupSequenceProvider(Class<?> beanClass, Class<T> defaultGroupSequenceProviderClass) {
        this.configuredClasses.add(beanClass);
        this.defaultGroupSequenceProviders.put(beanClass, defaultGroupSequenceProviderClass);
    }

    public final void addConstraintConfig(ConfiguredConstraint<?, BeanConstraintLocation> constraint) {
        Class<?> beanClass = constraint.getLocation().getBeanClass();
        this.configuredClasses.add(beanClass);
        if (this.constraintConfig.containsKey(beanClass)) {
            this.constraintConfig.get(beanClass).add(constraint);
        } else {
            ArrayList definitionList = CollectionHelper.newArrayList();
            definitionList.add(constraint);
            this.constraintConfig.put(beanClass, definitionList);
        }
    }

    public final void addMethodConstraintConfig(ConfiguredConstraint<?, MethodConstraintLocation> constraint) {
        Class<?> beanClass = constraint.getLocation().getBeanClass();
        this.configuredClasses.add(beanClass);
        if (this.methodConstraintConfig.containsKey(beanClass)) {
            this.methodConstraintConfig.get(beanClass).add(constraint);
        } else {
            ArrayList definitionList = CollectionHelper.newArrayList();
            definitionList.add(constraint);
            this.methodConstraintConfig.put(beanClass, definitionList);
        }
    }

    private static class ConstraintMappingContextAccessor
    extends ConstraintMapping {
        private ConstraintMappingContextAccessor(ConstraintMapping original) {
            super(original);
        }

        private ConstraintMappingContext getContext() {
            return this.context;
        }
    }
}

