/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.nodes;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.tools.Diagnostic;
import org.netbeans.modules.openide.nodes.NodesRegistrationSupport;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.nodes.BeanInfoSearchPath;
import org.openide.nodes.PropertyEditorRegistration;
import org.openide.nodes.PropertyEditorSearchPath;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class NodesAnnotationProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(PropertyEditorSearchPath.class.getName());
        hashSet.add(PropertyEditorRegistration.class.getName());
        hashSet.add(BeanInfoSearchPath.class.getName());
        return hashSet;
    }

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        Object object;
        Object object2;
        Object object3;
        String string;
        Messager messager = this.processingEnv.getMessager();
        for (Element element : roundEnvironment.getElementsAnnotatedWith(PropertyEditorSearchPath.class)) {
            string = this.findPackage(element);
            object3 = string.replace(".", "-");
            object2 = this.layer(new Element[]{element});
            object = object2.file("Services/PropertyEditorManager/Package-" + (String)object3 + ".instance");
            object.methodvalue("instanceCreate", NodesRegistrationSupport.class.getName(), "createPackageRegistration");
            object.stringvalue("packagePath", string);
            object.stringvalue("instanceOf", NodesRegistrationSupport.PEPackageRegistration.class.getName());
            object.write();
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(PropertyEditorRegistration.class)) {
            AnnotationMirror annotationMirror;
            if (element.getKind() != ElementKind.CLASS) continue;
            string = ((TypeElement)element).getQualifiedName().toString();
            object3 = null;
            object2 = element.getAnnotationMirrors();
            object = object2.iterator();
            while (object.hasNext()) {
                annotationMirror = (AnnotationMirror)object.next();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!"targetType".equals(entry.getKey().getSimpleName().toString())) continue;
                    object3 = (Collection)entry.getValue().getValue();
                }
            }
            if (object3 == null) {
                messager.printMessage(Diagnostic.Kind.ERROR, "No targetType is specified", element);
                continue;
            }
            object = this.processingEnv.getElementUtils().getTypeElement("java.beans.PropertyEditor");
            if (!this.processingEnv.getTypeUtils().isSubtype(element.asType(), object.asType())) {
                messager.printMessage(Diagnostic.Kind.ERROR, string + " is not subtype of PropertyEditor", element);
                continue;
            }
            annotationMirror = this.layer(new Element[]{element});
            String string2 = string.replace(".", "-");
            LayerBuilder.File file = annotationMirror.instanceFile("Services/PropertyEditorManager", "Class-" + (String)string2);
            file.methodvalue("instanceCreate", NodesRegistrationSupport.class.getName(), "createClassRegistration");
            file.stringvalue("propertyEditorClass", string);
            file.stringvalue("instanceOf", NodesRegistrationSupport.PEClassRegistration.class.getName());
            int n = 1;
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                AnnotationValue annotationValue = (AnnotationValue)iterator.next();
                String string3 = annotationValue.accept(new SimpleAnnotationValueVisitor6<String, Object>(){

                    @Override
                    public String visitType(TypeMirror typeMirror, Object object) {
                        return typeMirror.toString();
                    }
                }, null);
                file.stringvalue("targetType." + n, string3);
                ++n;
            }
            file.write();
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(BeanInfoSearchPath.class)) {
            string = this.findPackage(element);
            object3 = string.replace(".", "-");
            object2 = this.layer(new Element[]{element});
            object = object2.file("Services/Introspector/BeanInfo-" + (String)object3 + ".instance");
            object.methodvalue("instanceCreate", NodesRegistrationSupport.class.getName(), "createBeanInfoRegistration");
            object.stringvalue("packagePath", string);
            object.stringvalue("instanceOf", NodesRegistrationSupport.BeanInfoRegistration.class.getName());
            object.write();
        }
        return true;
    }

    private String findPackage(Element element) {
        switch (element.getKind()) {
            case PACKAGE: {
                return ((PackageElement)element).getQualifiedName().toString();
            }
        }
        return this.findPackage(element.getEnclosingElement());
    }
}

