/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.clientmodule;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyDescriptorFactory;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetaData;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetaData;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;

public class ClientModuleResolver
implements ComponentMetaDataResolver {
    private final ComponentMetaDataResolver resolver;
    private final DependencyDescriptorFactory dependencyDescriptorFactory;

    public ClientModuleResolver(ComponentMetaDataResolver resolver, DependencyDescriptorFactory dependencyDescriptorFactory) {
        this.resolver = resolver;
        this.dependencyDescriptorFactory = dependencyDescriptorFactory;
    }

    public void resolve(ComponentIdentifier identifier, ComponentOverrideMetadata componentOverrideMetadata, BuildableComponentResolveResult result) {
        this.resolver.resolve(identifier, componentOverrideMetadata, result);
        if (result.getFailure() != null) {
            return;
        }
        ClientModule clientModule = componentOverrideMetadata.getClientModule();
        if (clientModule != null) {
            MutableModuleComponentResolveMetaData clientModuleMetaData = ((MutableModuleComponentResolveMetaData)result.getMetaData()).copy();
            this.addClientModuleDependencies(clientModule, clientModuleMetaData);
            this.setClientModuleArtifact(clientModuleMetaData);
            result.setMetaData(clientModuleMetaData);
        }
    }

    private void addClientModuleDependencies(ClientModule clientModule, MutableModuleComponentResolveMetaData clientModuleMetaData) {
        ArrayList dependencies = Lists.newArrayList();
        for (ModuleDependency moduleDependency : clientModule.getDependencies()) {
            DependencyMetaData dependencyMetaData = this.dependencyDescriptorFactory.createDependencyDescriptor(moduleDependency.getConfiguration(), moduleDependency);
            dependencies.add(dependencyMetaData);
        }
        clientModuleMetaData.setDependencies(dependencies);
    }

    private void setClientModuleArtifact(MutableModuleComponentResolveMetaData clientModuleMetaData) {
        ModuleComponentArtifactMetaData artifact = clientModuleMetaData.artifact("jar", "jar", null);
        clientModuleMetaData.setArtifacts(Sets.newHashSet((Object[])new ModuleComponentArtifactMetaData[]{artifact}));
    }
}

