/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.bootstrap;

import org.gradle.BuildExceptionReporter;
import org.gradle.api.Action;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.launcher.bootstrap.ExecutionCompleter;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.bootstrap.ProcessCompleter;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.logging.internal.StreamingStyledTextOutputFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntryPoint {
    public void run(String[] args) {
        RecordingExecutionListener listener = new RecordingExecutionListener();
        try {
            this.doAction(args, listener);
        }
        catch (Throwable e) {
            this.createErrorHandler().execute(e);
            listener.onFailure(e);
        }
        Throwable failure = listener.getFailure();
        ExecutionCompleter completer = this.createCompleter();
        if (failure == null) {
            completer.complete();
        } else {
            completer.completeWithFailure(failure);
        }
    }

    protected ExecutionCompleter createCompleter() {
        return new ProcessCompleter();
    }

    protected Action<Throwable> createErrorHandler() {
        return new BuildExceptionReporter(new StreamingStyledTextOutputFactory(System.err), new LoggingConfiguration(), new GradleLauncherMetaData());
    }

    protected abstract void doAction(String[] var1, ExecutionListener var2);

    private static class RecordingExecutionListener
    implements ExecutionListener {
        private Throwable failure;

        private RecordingExecutionListener() {
        }

        public void onFailure(Throwable failure) {
            this.failure = failure;
        }

        public Throwable getFailure() {
            return this.failure;
        }
    }
}

