/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.internal;

import groovy.lang.Closure;
import java.util.SortedMap;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.ReportContainer;
import org.gradle.api.specs.Spec;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReportContainer<T extends Report>
extends DefaultNamedDomainObjectSet<T>
implements ReportContainer<T> {
    private NamedDomainObjectSet<T> enabled = this.matching(new Spec<T>(){

        public boolean isSatisfiedBy(T element) {
            return element.isEnabled();
        }
    });

    public DefaultReportContainer(Class<? extends T> type, Instantiator instantiator) {
        super(type, instantiator, Report.NAMER);
        this.beforeChange(new Runnable(){

            public void run() {
                throw new ReportContainer.ImmutableViolationException();
            }
        });
    }

    @Override
    public NamedDomainObjectSet<T> getEnabled() {
        return this.enabled;
    }

    public ReportContainer<T> configure(Closure cl) {
        ConfigureUtil.configure((Closure)cl, (Object)this, (boolean)false);
        return this;
    }

    public T getFirstEnabled() {
        SortedMap map = this.enabled.getAsMap();
        if (map.isEmpty()) {
            return null;
        }
        return (T)((Report)map.get(map.firstKey()));
    }

    protected <N extends T> N add(Class<N> clazz, Object ... constructionArgs) {
        Report report = (Report)this.getInstantiator().newInstance(clazz, constructionArgs);
        if (report.getName().equals("enabled")) {
            throw new InvalidUserDataException("Reports that are part of a ReportContainer cannot be named 'enabled'");
        }
        this.getStore().add(report);
        this.index();
        return (N)report;
    }
}

