/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddPrimitivesCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveDeepCopy;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class PasteAction
extends JosmAction
implements PrimitiveDeepCopy.PasteBufferChangedListener {
    public PasteAction() {
        super(I18n.tr("Paste", new Object[0]), "paste", I18n.tr("Paste contents of paste buffer.", new Object[0]), Shortcut.registerShortcut("system:paste", I18n.tr("Edit: {0}", I18n.tr("Paste", new Object[0])), 86, 5006), true);
        this.putValue("help", HelpUtil.ht("/Action/Paste"));
        Main.registerActionShortcut(this, Shortcut.registerShortcut("system:paste:cua", I18n.tr("Edit: {0}", I18n.tr("Paste", new Object[0])), 155, 5005));
        Main.pasteBuffer.addPasteBufferChangedListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.pasteData(Main.pasteBuffer, Main.pasteSource, actionEvent);
    }

    public void pasteData(PrimitiveDeepCopy primitiveDeepCopy, Layer layer, ActionEvent actionEvent) {
        Serializable serializable;
        Serializable serializable2;
        double d = -1.0E100;
        double d2 = 1.0E100;
        double d3 = -1.0E100;
        double d4 = 1.0E100;
        boolean bl = false;
        for (Serializable serializable3 : primitiveDeepCopy.getAll()) {
            if (serializable3 instanceof NodeData && (serializable2 = (NodeData)serializable3).getEastNorth() != null) {
                double d5 = serializable2.getEastNorth().east();
                double d6 = serializable2.getEastNorth().north();
                if (d5 > d) {
                    d = d5;
                }
                if (d5 < d2) {
                    d2 = d5;
                }
                if (d6 > d3) {
                    d3 = d6;
                }
                if (d6 < d4) {
                    d4 = d6;
                }
            }
            if (!serializable3.isIncomplete()) continue;
            bl = true;
        }
        if (bl && !PasteAction.confirmDeleteIncomplete()) {
            return;
        }
        Object object = Main.map.mapView.getCenter();
        if (actionEvent != null && !this.getValue("Name").equals(actionEvent.getActionCommand())) {
            Serializable serializable3;
            serializable3 = MouseInfo.getPointerInfo().getLocation();
            serializable2 = Main.map.mapView.getLocationOnScreen();
            Point point = new Point(((Point)serializable3).x - ((Point)serializable2).x, ((Point)serializable3).y - ((Point)serializable2).y);
            if (Main.map.mapView.contains(point)) {
                object = Main.map.mapView.getEastNorth(point.x, point.y);
            }
        }
        double d7 = ((EastNorth)object).east() - (d + d2) / 2.0;
        double d8 = ((EastNorth)object).north() - (d3 + d4) / 2.0;
        ArrayList<PrimitiveData> arrayList = new ArrayList<PrimitiveData>();
        ArrayList<PrimitiveData> arrayList2 = new ArrayList<PrimitiveData>();
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        HashMap<Long, Long> hashMap2 = new HashMap<Long, Long>();
        HashMap<Long, Long> hashMap3 = new HashMap<Long, Long>();
        for (PrimitiveData primitiveData : primitiveDeepCopy.getAll()) {
            if (primitiveData.isIncomplete()) continue;
            serializable = primitiveData.makeCopy();
            ((AbstractPrimitive)((Object)serializable)).clearOsmMetadata();
            if (primitiveData instanceof NodeData) {
                hashMap.put(primitiveData.getUniqueId(), ((AbstractPrimitive)((Object)serializable)).getUniqueId());
            } else if (primitiveData instanceof WayData) {
                hashMap2.put(primitiveData.getUniqueId(), ((AbstractPrimitive)((Object)serializable)).getUniqueId());
            } else if (primitiveData instanceof RelationData) {
                hashMap3.put(primitiveData.getUniqueId(), ((AbstractPrimitive)((Object)serializable)).getUniqueId());
            }
            arrayList.add((PrimitiveData)serializable);
            if (!primitiveDeepCopy.getDirectlyAdded().contains(primitiveData)) continue;
            arrayList2.add((PrimitiveData)serializable);
        }
        for (PrimitiveData primitiveData : arrayList) {
            Object object2;
            if (primitiveData instanceof NodeData) {
                serializable = (NodeData)primitiveData;
                if (Main.main.getEditLayer() != layer) continue;
                ((NodeData)serializable).setEastNorth(((NodeData)serializable).getEastNorth().add(d7, d8));
                continue;
            }
            if (primitiveData instanceof WayData) {
                serializable = new ArrayList();
                for (Long l : ((WayData)primitiveData).getNodes()) {
                    object2 = (Long)hashMap.get(l);
                    if (object2 == null) continue;
                    serializable.add(object2);
                }
                ((WayData)primitiveData).setNodes((List<Long>)((Object)serializable));
                continue;
            }
            if (!(primitiveData instanceof RelationData)) continue;
            serializable = new ArrayList();
            for (RelationMemberData relationMemberData : ((RelationData)primitiveData).getMembers()) {
                Long l;
                object2 = relationMemberData.getMemberType();
                switch (1.$SwitchMap$org$openstreetmap$josm$data$osm$OsmPrimitiveType[((Enum)object2).ordinal()]) {
                    case 1: {
                        l = (Long)hashMap.get(relationMemberData.getMemberId());
                        break;
                    }
                    case 2: {
                        l = (Long)hashMap2.get(relationMemberData.getMemberId());
                        break;
                    }
                    case 3: {
                        l = (Long)hashMap3.get(relationMemberData.getMemberId());
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                if (l == null) continue;
                serializable.add(new RelationMemberData(relationMemberData.getRole(), (OsmPrimitiveType)((Object)object2), l));
            }
            ((RelationData)primitiveData).setMembers((List<RelationMemberData>)((Object)serializable));
        }
        Main.main.undoRedo.add(new AddPrimitivesCommand(arrayList, arrayList2));
        Main.map.mapView.repaint();
    }

    private static boolean confirmDeleteIncomplete() {
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Delete incomplete members?", new Object[0]), new String[]{I18n.tr("Paste without incomplete members", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"dialogs/relation/deletemembers", "cancel"});
        extendedDialog.setContent(I18n.tr("The copied data contains incomplete objects.  When pasting the incomplete objects are removed.  Do you want to paste the data without the incomplete objects?", new Object[0]));
        extendedDialog.showDialog();
        return extendedDialog.getValue() == 1;
    }

    @Override
    protected void updateEnabledState() {
        if (PasteAction.getCurrentDataSet() == null || Main.pasteBuffer == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!Main.pasteBuffer.isEmpty());
    }

    @Override
    public void pasteBufferChanged(PrimitiveDeepCopy primitiveDeepCopy) {
        this.updateEnabledState();
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$openstreetmap$josm$data$osm$OsmPrimitiveType;

        static {
            $SwitchMap$org$openstreetmap$josm$data$osm$OsmPrimitiveType = new int[OsmPrimitiveType.values().length];
            try {
                1.$SwitchMap$org$openstreetmap$josm$data$osm$OsmPrimitiveType[OsmPrimitiveType.NODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$openstreetmap$josm$data$osm$OsmPrimitiveType[OsmPrimitiveType.WAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$openstreetmap$josm$data$osm$OsmPrimitiveType[OsmPrimitiveType.RELATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

