/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import java.nio.charset.StandardCharsets;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;

@NodeChildren(value={@NodeChild(value="value", type=FormatNode.class)})
public abstract class FormatFloatNode
extends FormatNode {
    private final String infiniteFormatString;
    private final String finiteFormatString;

    public FormatFloatNode(RubyContext context, int spacePadding, int zeroPadding, int precision, char format) {
        super(context);
        StringBuilder inifiniteFormatBuilder = new StringBuilder();
        inifiniteFormatBuilder.append("%");
        if (spacePadding != -1) {
            inifiniteFormatBuilder.append(" ");
            inifiniteFormatBuilder.append(spacePadding + 5);
        }
        if (zeroPadding != -1 && zeroPadding != 0) {
            inifiniteFormatBuilder.append("0");
            inifiniteFormatBuilder.append(zeroPadding + 5);
        }
        inifiniteFormatBuilder.append(format);
        this.infiniteFormatString = inifiniteFormatBuilder.toString();
        StringBuilder finiteFormatBuilder = new StringBuilder();
        finiteFormatBuilder.append("%");
        if (spacePadding != -1) {
            finiteFormatBuilder.append(" ");
            finiteFormatBuilder.append(spacePadding);
            if (zeroPadding != -1) {
                finiteFormatBuilder.append(".");
                finiteFormatBuilder.append(zeroPadding);
            }
        } else if (zeroPadding != -1 && zeroPadding != 0) {
            finiteFormatBuilder.append("0");
            finiteFormatBuilder.append(zeroPadding);
        }
        if (precision != -1) {
            finiteFormatBuilder.append(".");
            finiteFormatBuilder.append(precision);
        }
        finiteFormatBuilder.append(format);
        this.finiteFormatString = finiteFormatBuilder.toString();
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isInfinite(value)"})
    public byte[] formatInfinite(double value) {
        String infinityString = String.format(this.infiniteFormatString, value);
        String shortenInfinityString = infinityString.substring(0, infinityString.length() - 5);
        return shortenInfinityString.getBytes(StandardCharsets.US_ASCII);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!isInfinite(value)"})
    public byte[] formatFinite(double value) {
        return String.format(this.finiteFormatString, value).getBytes(StandardCharsets.US_ASCII);
    }

    protected boolean isInfinite(double value) {
        return Double.isInfinite(value);
    }
}

