/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.filter.FilterAdaptor;
import org.parosproxy.paros.network.HttpMessage;

public class FilterLogRequestResponse
extends FilterAdaptor {
    private static final String logFile = "filter/message.txt";
    private static final String delim = "====================================";
    private static final String CRLF = "\r\n";
    private File outFile = new File("filter/message.txt");
    private BufferedWriter writer = null;
    private long lastWriteTime = System.currentTimeMillis();
    private int counter = 1;
    private Logger logger = Logger.getLogger(FilterLogRequestResponse.class);

    @Override
    public int getId() {
        return 40;
    }

    @Override
    public String getName() {
        return Constant.messages.getString("filter.logreqresp.name") + logFile;
    }

    @Override
    public void onHttpRequestSend(HttpMessage httpMessage) {
    }

    @Override
    public void onHttpResponseReceive(HttpMessage httpMessage) {
        if (!httpMessage.getRequestHeader().isText() || httpMessage.getRequestHeader().isImage() || httpMessage.getResponseHeader().isImage()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(httpMessage.getRequestHeader().toString());
        stringBuilder.append(httpMessage.getRequestBody().toString()).append(CRLF);
        if (!httpMessage.getResponseHeader().isEmpty()) {
            stringBuilder.append(httpMessage.getResponseHeader().toString());
            stringBuilder.append(httpMessage.getResponseBody().toString()).append(CRLF);
        }
        this.writeLogFile(stringBuilder.toString());
    }

    private synchronized void writeLogFile(String string) {
        try {
            if (this.getWriter() != null) {
                this.getWriter().write("===== " + this.counter + " " + delim + CRLF);
                this.getWriter().write(string + CRLF);
                ++this.counter;
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public synchronized void timer() {
        if (this.writer != null && System.currentTimeMillis() > this.lastWriteTime + 5000L) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (IOException iOException) {
                this.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    private synchronized BufferedWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new BufferedWriter(new FileWriter(this.outFile, true));
        }
        return this.writer;
    }
}

