/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.params;

import java.util.HashSet;
import java.util.Set;
import org.parosproxy.paros.network.HtmlParameter;

public class HtmlParameterStats
implements Comparable<HtmlParameterStats> {
    private long id = -1L;
    private String site;
    private String name;
    private HtmlParameter.Type type;
    private int timesUsed = 0;
    private Set<String> flags = new HashSet<String>();
    private Set<String> values = new HashSet<String>();

    public HtmlParameterStats(String string, String string2, HtmlParameter.Type type, String string3, Set<String> set) {
        this.site = string;
        this.name = string2;
        this.type = type;
        this.addValue(string3);
        this.flags = set;
        this.incTimesUsed();
    }

    public HtmlParameterStats(long l, String string, String string2, String string3, int n, Set<String> set, Set<String> set2) {
        this.id = l;
        this.site = string;
        this.name = string2;
        this.type = HtmlParameter.Type.valueOf(string3);
        this.timesUsed = n;
        this.values = set;
        this.flags = set2;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public String getSite() {
        return this.site;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public HtmlParameter.Type getType() {
        return this.type;
    }

    public void setType(HtmlParameter.Type type) {
        this.type = type;
    }

    public int getTimesUsed() {
        return this.timesUsed;
    }

    public void incTimesUsed() {
        ++this.timesUsed;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public void addValue(String string) {
        if (string == null) {
            string = "";
        }
        this.values.add(string);
    }

    public String getValuesSummary() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.values) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            if (stringBuilder.length() <= 250) continue;
            break;
        }
        return stringBuilder.toString();
    }

    public Set<String> getFlags() {
        return this.flags;
    }

    public void addFlag(String string) {
        this.flags.add(string);
    }

    public String getAllFlags() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.flags) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            if (stringBuilder.length() <= 250) continue;
            break;
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(HtmlParameterStats htmlParameterStats) {
        if (htmlParameterStats == null) {
            return 1;
        }
        int n = this.type.ordinal() - htmlParameterStats.getType().ordinal();
        if (n == 0) {
            n = this.name.compareTo(htmlParameterStats.getName());
        }
        return n;
    }

    public void removeFlag(String string) {
        this.flags.remove(string);
    }
}

