/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.extension.pscan.scanner.RegexAutoTagScanner;

public class PassiveScannerList {
    private static final Logger logger = Logger.getLogger(PassiveScannerList.class);
    private List<PassiveScanner> passiveScanners = new ArrayList<PassiveScanner>();
    private Set<String> scannerNames = new HashSet<String>();

    protected boolean add(PassiveScanner passiveScanner) {
        if (this.scannerNames.contains(passiveScanner.getName())) {
            return false;
        }
        this.passiveScanners.add(passiveScanner);
        this.scannerNames.add(passiveScanner.getName());
        return true;
    }

    protected List<PassiveScanner> list() {
        return this.passiveScanners;
    }

    public void setAutoTagScanners(List<RegexAutoTagScanner> list) {
        ArrayList<PassiveScanner> arrayList = new ArrayList<PassiveScanner>(this.passiveScanners.size() + list.size());
        for (PassiveScanner passiveScanner : this.passiveScanners) {
            if (!(passiveScanner instanceof RegexAutoTagScanner)) {
                arrayList.add(passiveScanner);
                continue;
            }
            this.scannerNames.remove(passiveScanner.getName());
        }
        for (PassiveScanner passiveScanner : list) {
            if (this.scannerNames.contains(passiveScanner.getName())) {
                logger.error((Object)("Duplicate passive scanner name: " + passiveScanner.getName()));
                continue;
            }
            arrayList.add(passiveScanner);
            this.scannerNames.add(passiveScanner.getName());
        }
        this.passiveScanners = arrayList;
    }

    public PassiveScanner removeScanner(String string) {
        for (PassiveScanner passiveScanner : this.passiveScanners) {
            if (!passiveScanner.getClass().getName().equals(string)) continue;
            this.scannerNames.remove(passiveScanner.getName());
            this.passiveScanners.remove(passiveScanner);
            return passiveScanner;
        }
        return null;
    }
}

