/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableColumnManager
implements MouseListener,
ActionListener,
TableColumnModelListener,
PropertyChangeListener {
    private JTable table;
    private TableColumnModel columnModel;
    private boolean menuPopup;
    private List<TableColumn> allColumns;

    public TableColumnManager(JTable jTable) {
        this(jTable, true);
    }

    public TableColumnManager(JTable jTable, boolean bl) {
        this.table = jTable;
        this.setMenuPopup(bl);
        jTable.addPropertyChangeListener(this);
        this.reset();
    }

    public void reset() {
        this.table.getColumnModel().removeColumnModelListener(this);
        this.columnModel = this.table.getColumnModel();
        this.columnModel.addColumnModelListener(this);
        int n = this.columnModel.getColumnCount();
        this.allColumns = new ArrayList<TableColumn>(n);
        for (int i = 0; i < n; ++i) {
            this.allColumns.add(this.columnModel.getColumn(i));
        }
    }

    public boolean isMenuPopup() {
        return this.menuPopup;
    }

    public void setMenuPopup(boolean bl) {
        this.table.getTableHeader().removeMouseListener(this);
        if (bl) {
            this.table.getTableHeader().addMouseListener(this);
        }
        this.menuPopup = bl;
    }

    public void hideColumn(int n) {
        int n2 = this.table.convertColumnIndexToView(n);
        if (n2 != -1) {
            TableColumn tableColumn = this.columnModel.getColumn(n2);
            this.hideColumn(tableColumn);
        }
    }

    public void hideColumn(Object object) {
        if (object == null) {
            return;
        }
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = this.columnModel.getColumn(i);
            if (!object.equals(tableColumn.getHeaderValue())) continue;
            this.hideColumn(tableColumn);
            break;
        }
    }

    public void hideColumn(TableColumn tableColumn) {
        if (this.columnModel.getColumnCount() == 1) {
            return;
        }
        this.columnModel.removeColumnModelListener(this);
        this.columnModel.removeColumn(tableColumn);
        this.columnModel.addColumnModelListener(this);
    }

    public void showColumn(int n) {
        for (TableColumn tableColumn : this.allColumns) {
            if (tableColumn.getModelIndex() != n) continue;
            this.showColumn(tableColumn);
            break;
        }
    }

    public void showColumn(Object object) {
        for (TableColumn tableColumn : this.allColumns) {
            if (!tableColumn.getHeaderValue().equals(object)) continue;
            this.showColumn(tableColumn);
            break;
        }
    }

    private void showColumn(TableColumn tableColumn) {
        this.columnModel.removeColumnModelListener(this);
        this.columnModel.addColumn(tableColumn);
        int n = this.allColumns.indexOf(tableColumn);
        int n2 = this.columnModel.getColumnCount() - 1;
        int n3 = 0;
        for (int i = n - 1; i > -1; --i) {
            try {
                TableColumn tableColumn2 = this.allColumns.get(i);
                n3 = this.columnModel.getColumnIndex(tableColumn2.getHeaderValue()) + 1;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        this.columnModel.moveColumn(n2, n3);
        this.columnModel.addColumnModelListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.checkForPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkForPopup(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void checkForPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getComponent();
            int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
            this.showPopup(n);
        }
    }

    private void showPopup(int n) {
        Serializable serializable2;
        Object object = this.columnModel.getColumn(n).getHeaderValue();
        int n2 = this.columnModel.getColumnCount();
        SelectPopupMenu selectPopupMenu = new SelectPopupMenu();
        for (Serializable serializable2 : this.allColumns) {
            Object object2 = serializable2.getHeaderValue();
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(object2.toString());
            jCheckBoxMenuItem.addActionListener(this);
            try {
                this.columnModel.getColumnIndex(object2);
                jCheckBoxMenuItem.setSelected(true);
                if (n2 == 1) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                jCheckBoxMenuItem.setSelected(false);
            }
            selectPopupMenu.add(jCheckBoxMenuItem);
            if (object2 != object) continue;
            ((JPopupMenu)selectPopupMenu).setSelected(jCheckBoxMenuItem);
        }
        JTableHeader jTableHeader = this.table.getTableHeader();
        serializable2 = jTableHeader.getHeaderRect(n);
        selectPopupMenu.show(jTableHeader, ((Rectangle)serializable2).x, ((Rectangle)serializable2).height);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (jMenuItem.isSelected()) {
            this.showColumn(jMenuItem.getText());
        } else {
            this.hideColumn(jMenuItem.getText());
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        TableColumn tableColumn = this.columnModel.getColumn(tableColumnModelEvent.getToIndex());
        if (!this.allColumns.contains(tableColumn)) {
            this.allColumns.add(tableColumn);
        }
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (tableColumnModelEvent.getFromIndex() == tableColumnModelEvent.getToIndex()) {
            return;
        }
        int n = tableColumnModelEvent.getToIndex();
        TableColumn tableColumn = this.columnModel.getColumn(n);
        this.allColumns.remove(tableColumn);
        if (n == 0) {
            this.allColumns.add(0, tableColumn);
        } else {
            TableColumn tableColumn2 = this.columnModel.getColumn(--n);
            int n2 = this.allColumns.indexOf(tableColumn2);
            this.allColumns.add(n2 + 1, tableColumn);
        }
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName()) && this.table.getAutoCreateColumnsFromModel()) {
            this.reset();
        }
    }

    class SelectPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 918018121618942657L;

        SelectPopupMenu() {
        }

        @Override
        public void setSelected(Component component) {
            int n = this.getComponentIndex(component);
            this.getSelectionModel().setSelectedIndex(n);
            final MenuElement[] menuElementArray = new MenuElement[]{this, this.getSubElements()[n]};
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                }
            });
        }
    }
}

