/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.Delete;
import org.gradle.language.base.internal.plugins.CleanRule;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class LifecycleBasePlugin
implements Plugin<ProjectInternal> {
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String ASSEMBLE_TASK_NAME = "assemble";
    public static final String CHECK_TASK_NAME = "check";
    public static final String BUILD_TASK_NAME = "build";
    public static final String BUILD_GROUP = "build";
    public static final String VERIFICATION_GROUP = "verification";
    private static final String CUSTOM_LIFECYCLE_TASK_DEPRECATION_MSG = "Defining custom '%s' task when using the standard Gradle lifecycle plugins";
    private final Set<String> placeholders = new HashSet<String>();

    public void apply(ProjectInternal project) {
        this.addClean(project);
        this.addCleanRule((Project)project);
        this.addAssemble(project);
        this.addCheck(project);
        this.addBuild(project);
        this.addDeprecationWarningsAboutCustomLifecycleTasks(project);
    }

    private void addClean(final ProjectInternal project) {
        this.addPlaceholderAction(project, CLEAN_TASK_NAME, Delete.class, new Action<Delete>(){

            public void execute(Delete clean) {
                clean.setDescription("Deletes the build directory.");
                clean.setGroup("build");
                clean.delete(new Object[]{new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return project.getBuildDir();
                    }
                }});
            }
        });
    }

    private void addCleanRule(Project project) {
        project.getTasks().addRule((Rule)new CleanRule(project.getTasks()));
    }

    private void addAssemble(ProjectInternal project) {
        this.addPlaceholderAction(project, ASSEMBLE_TASK_NAME, DefaultTask.class, new Action<TaskInternal>(){

            public void execute(TaskInternal assembleTask) {
                assembleTask.setDescription("Assembles the outputs of this project.");
                assembleTask.setGroup("build");
            }
        });
    }

    private void addCheck(ProjectInternal project) {
        this.addPlaceholderAction(project, CHECK_TASK_NAME, DefaultTask.class, new Action<TaskInternal>(){

            public void execute(TaskInternal checkTask) {
                checkTask.setDescription("Runs all checks.");
                checkTask.setGroup(LifecycleBasePlugin.VERIFICATION_GROUP);
            }
        });
    }

    private void addBuild(ProjectInternal project) {
        this.addPlaceholderAction(project, "build", DefaultTask.class, new Action<DefaultTask>(){

            public void execute(DefaultTask buildTask) {
                buildTask.setDescription("Assembles and tests this project.");
                buildTask.setGroup("build");
                buildTask.dependsOn(new Object[]{LifecycleBasePlugin.ASSEMBLE_TASK_NAME});
                buildTask.dependsOn(new Object[]{LifecycleBasePlugin.CHECK_TASK_NAME});
            }
        });
    }

    <T extends TaskInternal> void addPlaceholderAction(ProjectInternal project, String placeholderName, Class<T> type, final Action<? super T> configure) {
        this.placeholders.add(placeholderName);
        project.getTasks().addPlaceholderAction(placeholderName, type, new Action<T>(){

            public void execute(T t) {
                t.getExtensions().getExtraProperties().set("placeholder", (Object)true);
                configure.execute(t);
            }
        });
    }

    private void addDeprecationWarningsAboutCustomLifecycleTasks(ProjectInternal project) {
        project.getTasks().all((Action)new Action<Task>(){

            public void execute(Task task) {
                if (LifecycleBasePlugin.this.placeholders.contains(task.getName()) && !task.getExtensions().getExtraProperties().has("placeholder")) {
                    DeprecationLogger.nagUserOfDeprecated((String)String.format(LifecycleBasePlugin.CUSTOM_LIFECYCLE_TASK_DEPRECATION_MSG, task.getName()));
                }
            }
        });
    }
}

