#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: generics-sop
version: 0.2.1.0
id: generics-sop-0.2.1.0-7239eda8d6e847745310ee1c6aedf3ba
key: gener_2ZGHFtoqAzKEbWPEaDqY6O
license: BSD3
maintainer: andres@well-typed.com
synopsis: Generic Programming using True Sums of Products
description:
    A library to support the definition of generic functions.
    Datatypes are viewed in a uniform, structured way:
    the choice between constructors is represented using an n-ary
    sum, and the arguments of each constructor are represented using
    an n-ary product.
    .
    The module "Generics.SOP" is the main module of this library and contains
    more detailed documentation.
    .
    Examples of using this library are provided by the following
    packages:
    .
    * @<https://hackage.haskell.org/package/basic-sop basic-sop>@ basic examples,
    .
    * @<https://hackage.haskell.org/package/pretty-sop pretty-sop>@ generic pretty printing,
    .
    * @<https://hackage.haskell.org/package/lens-sop lens-sop>@ generically computed lenses,
    .
    * @<https://hackage.haskell.org/package/json-sop json-sop>@ generic JSON conversions.
    .
    A detailed description of the ideas behind this library is provided by
    the paper:
    .
    * Edsko de Vries and Andres Löh.
    <http://www.andres-loeh.de/TrueSumsOfProducts True Sums of Products>.
    Workshop on Generic Programming (WGP) 2014.
    .
category: Generics
author: Edsko de Vries <edsko@well-typed.com>, Andres Löh <andres@well-typed.com>
exposed: True
exposed-modules:
    Generics.SOP Generics.SOP.GGP Generics.SOP.TH Generics.SOP.Dict
    Generics.SOP.BasicFunctors Generics.SOP.Classes
    Generics.SOP.Constraint Generics.SOP.Instances
    Generics.SOP.Metadata Generics.SOP.NP Generics.SOP.NS
    Generics.SOP.Universe Generics.SOP.Sing
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/generics-sop-0.2.1.0
library-dirs: /usr/lib/ghc-7.10.3/site-local/generics-sop-0.2.1.0
data-dir: /usr/share/arm-linux-ghc-7.10.3/generics-sop-0.2.1.0
hs-libraries: HSgenerics-sop-0.2.1.0-2ZGHFtoqAzKEbWPEaDqY6O
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    ghc-prim-0.4.0.0-bf246eb9fdda7435f0c147a313ce59fb
    template-haskell-2.10.0.0-4b92ab565139fd81021b60a162b59eb8
haddock-interfaces: /usr/share/doc/haskell-generics-sop/html/generics-sop.haddock
haddock-html: /usr/share/doc/haskell-generics-sop/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
