/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaInternalBlockBody
extends BlockBody {
    private final ThreadContext originalContext;
    private final String methodName;
    private final StaticScope dummyScope;

    public JavaInternalBlockBody(Ruby runtime, Signature signature) {
        this(runtime, null, null, signature);
    }

    public JavaInternalBlockBody(Ruby runtime, ThreadContext originalContext, String methodName, Signature signature) {
        super(signature);
        this.originalContext = originalContext;
        this.methodName = methodName;
        this.dummyScope = runtime.getStaticScopeFactory().getDummyScope();
    }

    private void threadCheck(ThreadContext yieldingContext) {
        if (this.originalContext != null && yieldingContext != this.originalContext) {
            throw yieldingContext.runtime.newThreadError(this.methodName + " cannot be parallelized");
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, Block block, IRubyObject[] args2) {
        return this.yield(context, block, args2, null);
    }

    @Override
    public IRubyObject call(ThreadContext context, Block b2, IRubyObject[] args2, Block blockArg) {
        return this.yield(context, b2, args2, null, blockArg);
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject value2) {
        this.threadCheck(context);
        return this.yield(context, new IRubyObject[]{value2});
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
        this.threadCheck(context);
        return this.yield(context, args2);
    }

    public abstract IRubyObject yield(ThreadContext var1, IRubyObject[] var2);

    @Override
    public StaticScope getStaticScope() {
        return this.dummyScope;
    }

    @Override
    public void setStaticScope(StaticScope newScope) {
    }

    @Override
    public String getFile() {
        return "(internal)";
    }

    @Override
    public int getLine() {
        return -1;
    }
}

