/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.Color;
import org.sejda.impl.sambox.component.PageTextWriter;
import org.sejda.model.HorizontalAlign;
import org.sejda.model.VerticalAlign;
import org.sejda.model.exception.TaskIOException;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.font.PDType1Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilenameFooterWriter {
    private static final Logger LOG = LoggerFactory.getLogger(FilenameFooterWriter.class);
    private boolean addFooter = false;
    private PageTextWriter writer;

    public FilenameFooterWriter(boolean addFooter, PDDocument document) {
        this.writer = new PageTextWriter(document);
        this.addFooter = addFooter;
    }

    public void addFooter(PDPage page, String fileName, long pageNumber) {
        if (this.addFooter) {
            try {
                this.writer.write(page, HorizontalAlign.LEFT, VerticalAlign.BOTTOM, fileName, PDType1Font.HELVETICA, 10.0, Color.BLACK);
                this.writer.write(page, HorizontalAlign.RIGHT, VerticalAlign.BOTTOM, Long.toString(pageNumber), PDType1Font.HELVETICA, 10.0, Color.BLACK);
            }
            catch (TaskIOException e) {
                LOG.warn("Unable to write the page footer", e);
            }
        }
    }
}

