/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content;

import java.util.ArrayList;
import org.videolan.media.content.BDHandler;
import org.videolan.media.content.playlist.Handler;

public class PlayerManager {
    private static PlayerManager instance = new PlayerManager();
    private ArrayList registeredPlayers = new ArrayList(1);
    private BDHandler playlistPlayer = null;
    private BDHandler videoDripPlayer = null;
    private Object playlistPlayerLock = new Object();
    private Object videoDripPlayerLock = new Object();
    private Object stoppingLock = new Object();
    private boolean stopping = false;

    public static PlayerManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllPlayers(boolean unconditional) {
        BDHandler[] players = null;
        ArrayList arrayList = this.registeredPlayers;
        synchronized (arrayList) {
            players = this.registeredPlayers.toArray(new BDHandler[0]);
        }
        for (int i = 0; i < players.length; ++i) {
            if (unconditional) {
                players[i].close();
                continue;
            }
            if (players[i].getOwnerContext() == null || !players[i].getOwnerContext().isReleased()) continue;
            players[i].close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BDHandler getPlaylistPlayer() {
        Object object = this.playlistPlayerLock;
        synchronized (object) {
            return this.playlistPlayer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseResource(BDHandler player) {
        if (player instanceof Handler) {
            Object object = this.playlistPlayerLock;
            synchronized (object) {
                if (player == this.playlistPlayer) {
                    this.playlistPlayer = null;
                }
            }
            return;
        }
        if (player instanceof org.videolan.media.content.sound.Handler) {
            return;
        }
        if (player instanceof org.videolan.media.content.audio.Handler) {
            return;
        }
        System.err.println("unknown player type: " + player.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allocateResource(BDHandler player) {
        if (player instanceof Handler) {
            Object object = this.stoppingLock;
            synchronized (object) {
                this.stopping = true;
            }
            object = this.playlistPlayerLock;
            synchronized (object) {
                if (this.playlistPlayer != null && player != this.playlistPlayer) {
                    this.playlistPlayer.stop();
                    this.playlistPlayer.deallocate();
                }
                this.playlistPlayer = player;
            }
            object = this.stoppingLock;
            synchronized (object) {
                this.stopping = false;
            }
            return true;
        }
        if (player instanceof org.videolan.media.content.sound.Handler) {
            return true;
        }
        if (player instanceof org.videolan.media.content.audio.Handler) {
            return true;
        }
        System.err.println("unknown player type: " + player.getClass().getName());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterPlayer(BDHandler player) {
        ArrayList arrayList = this.registeredPlayers;
        synchronized (arrayList) {
            if (this.registeredPlayers.contains(player)) {
                this.registeredPlayers.remove(player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerPlayer(BDHandler player) {
        ArrayList arrayList = this.registeredPlayers;
        synchronized (arrayList) {
            if (!this.registeredPlayers.contains(player)) {
                this.registeredPlayers.add(player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(int event, int param) {
        Object object = this.stoppingLock;
        synchronized (object) {
            if (this.stopping) {
                return;
            }
            Object object2 = this.playlistPlayerLock;
            synchronized (object2) {
                if (this.playlistPlayer != null) {
                    this.playlistPlayer.statusEvent(event, param);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRateChange(float rate) {
        Object object = this.stoppingLock;
        synchronized (object) {
            if (this.stopping) {
                return;
            }
            Object object2 = this.playlistPlayerLock;
            synchronized (object2) {
                if (this.playlistPlayer != null) {
                    this.playlistPlayer.rateChanged(rate);
                }
            }
        }
    }
}

