/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.SystemDialog;

public class Resource {
    private XIndexAccess xStringIndexAccess;

    public Resource(XMultiServiceFactory _xMSF, String _Module) {
        try {
            Object[] aArgs = new Object[]{_Module};
            XInterface xResource = (XInterface)_xMSF.createInstanceWithArguments("org.libreoffice.resource.ResourceIndexAccess", aArgs);
            if (xResource == null) {
                throw new Exception("could not initialize ResourceIndexAccess");
            }
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xResource);
            if (xNameAccess == null) {
                throw new Exception("ResourceIndexAccess is no XNameAccess");
            }
            this.xStringIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xNameAccess.getByName("String"));
            XIndexAccess xStringListIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xNameAccess.getByName("StringList"));
            if (xStringListIndexAccess == null) {
                throw new Exception("could not initialize xStringListIndexAccess");
            }
            if (this.xStringIndexAccess == null) {
                throw new Exception("could not initialize xStringIndexAccess");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Resource.showCommonResourceError(_xMSF);
        }
    }

    public String getResText(int nID) {
        try {
            return (String)this.xStringIndexAccess.getByIndex(nID);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Resource with ID not " + nID + "not found", exception);
        }
    }

    public String[] getResArray(int nID, int iCount) {
        try {
            String[] ResArray = new String[iCount];
            for (int i = 0; i < iCount; ++i) {
                ResArray[i] = this.getResText(nID + i);
            }
            return ResArray;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Resource with ID not" + nID + "not found", exception);
        }
    }

    public static void showCommonResourceError(XMultiServiceFactory xMSF) {
        String ProductName = Configuration.getProductName(xMSF);
        String sError = "The files required could not be found.\nPlease start the %PRODUCTNAME Setup and choose 'Repair'.";
        sError = JavaTools.replaceSubString(sError, ProductName, "%PRODUCTNAME");
        SystemDialog.showMessageBox(xMSF, "ErrorBox", 0x400000, sError);
    }
}

