/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.swing.tabcontrol.ButtonPopupSwitcher;
import org.netbeans.swing.tabcontrol.TabDisplayer;

public class TabListPopupAction
extends AbstractAction {
    private TabDisplayer displayer;

    public TabListPopupAction(TabDisplayer tabDisplayer) {
        this.displayer = tabDisplayer;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("pressed".equals(actionEvent.getActionCommand())) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            Point point = new Point(jComponent.getWidth(), jComponent.getHeight());
            SwingUtilities.convertPointToScreen(point, jComponent);
            if (!ButtonPopupSwitcher.isShown()) {
                ButtonPopupSwitcher.showPopup(jComponent, this.displayer, point.x, point.y);
            } else {
                ButtonPopupSwitcher.hidePopup();
            }
            if (jComponent instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)jComponent;
                abstractButton.getModel().setPressed(false);
                abstractButton.getModel().setRollover(false);
                abstractButton.getModel().setArmed(false);
                abstractButton.repaint();
            }
        }
    }
}

