/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.security.AlgorithmConstraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;

public class SSLParameters {
    private String[] cipherSuites;
    private String[] protocols;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private String identificationAlgorithm;
    private AlgorithmConstraints algorithmConstraints;
    private Map<Integer, SNIServerName> sniNames = null;
    private Map<Integer, SNIMatcher> sniMatchers = null;
    private boolean preferLocalCipherSuites;

    public SSLParameters() {
    }

    public SSLParameters(String[] stringArray) {
        this.setCipherSuites(stringArray);
    }

    public SSLParameters(String[] stringArray, String[] stringArray2) {
        this.setCipherSuites(stringArray);
        this.setProtocols(stringArray2);
    }

    private static String[] clone(String[] stringArray) {
        return stringArray == null ? null : (String[])stringArray.clone();
    }

    public String[] getCipherSuites() {
        return SSLParameters.clone(this.cipherSuites);
    }

    public void setCipherSuites(String[] stringArray) {
        this.cipherSuites = SSLParameters.clone(stringArray);
    }

    public String[] getProtocols() {
        return SSLParameters.clone(this.protocols);
    }

    public void setProtocols(String[] stringArray) {
        this.protocols = SSLParameters.clone(stringArray);
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
        this.needClientAuth = false;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean bl) {
        this.wantClientAuth = false;
        this.needClientAuth = bl;
    }

    public AlgorithmConstraints getAlgorithmConstraints() {
        return this.algorithmConstraints;
    }

    public void setAlgorithmConstraints(AlgorithmConstraints algorithmConstraints) {
        this.algorithmConstraints = algorithmConstraints;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.identificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String string) {
        this.identificationAlgorithm = string;
    }

    public final void setServerNames(List<SNIServerName> list) {
        if (list != null) {
            if (!list.isEmpty()) {
                this.sniNames = new LinkedHashMap<Integer, SNIServerName>(list.size());
                for (SNIServerName sNIServerName : list) {
                    if (this.sniNames.put(sNIServerName.getType(), sNIServerName) == null) continue;
                    throw new IllegalArgumentException("Duplicated server name of type " + sNIServerName.getType());
                }
            } else {
                this.sniNames = Collections.emptyMap();
            }
        } else {
            this.sniNames = null;
        }
    }

    public final List<SNIServerName> getServerNames() {
        if (this.sniNames != null) {
            if (!this.sniNames.isEmpty()) {
                return Collections.unmodifiableList(new ArrayList<SNIServerName>(this.sniNames.values()));
            }
            return Collections.emptyList();
        }
        return null;
    }

    public final void setSNIMatchers(Collection<SNIMatcher> collection) {
        if (collection != null) {
            if (!collection.isEmpty()) {
                this.sniMatchers = new HashMap<Integer, SNIMatcher>(collection.size());
                for (SNIMatcher sNIMatcher : collection) {
                    if (this.sniMatchers.put(sNIMatcher.getType(), sNIMatcher) == null) continue;
                    throw new IllegalArgumentException("Duplicated server name of type " + sNIMatcher.getType());
                }
            } else {
                this.sniMatchers = Collections.emptyMap();
            }
        } else {
            this.sniMatchers = null;
        }
    }

    public final Collection<SNIMatcher> getSNIMatchers() {
        if (this.sniMatchers != null) {
            if (!this.sniMatchers.isEmpty()) {
                return Collections.unmodifiableList(new ArrayList<SNIMatcher>(this.sniMatchers.values()));
            }
            return Collections.emptyList();
        }
        return null;
    }

    public final void setUseCipherSuitesOrder(boolean bl) {
        this.preferLocalCipherSuites = bl;
    }

    public final boolean getUseCipherSuitesOrder() {
        return this.preferLocalCipherSuites;
    }
}

