/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.plugins;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.WordUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;
import org.gradle.internal.Cast;
import org.gradle.internal.Transformers;
import org.gradle.internal.component.local.model.DefaultLibraryBinaryIdentifier;
import org.gradle.internal.component.local.model.UsageKind;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.JvmBinarySpec;
import org.gradle.jvm.internal.DependencyResolvingClasspath;
import org.gradle.jvm.internal.JvmAssembly;
import org.gradle.jvm.internal.JvmBinarySpecInternal;
import org.gradle.jvm.internal.WithJvmAssembly;
import org.gradle.jvm.test.JvmTestSuiteBinarySpec;
import org.gradle.jvm.test.internal.JvmTestSuiteBinarySpecInternal;
import org.gradle.language.base.DependentSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.model.DefaultVariantsMetaData;
import org.gradle.language.base.internal.resolve.LocalComponentResolveContext;
import org.gradle.model.Each;
import org.gradle.model.Finalize;
import org.gradle.model.ModelMap;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultLibraryBinaryDependencySpec;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class JvmTestSuiteBasePlugin
extends RuleSource {
    @BinaryTasks
    void createJvmTestSuiteTasks(ModelMap<Task> tasks, final JvmTestSuiteBinarySpecInternal binary, final @Path(value="buildDir") File buildDir) {
        final JvmAssembly jvmAssembly = ((WithJvmAssembly)binary).getAssembly();
        tasks.create(JvmTestSuiteBasePlugin.testTaskNameFor(binary), Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                test.setGroup("verification");
                test.setDescription(String.format("Runs %s.", WordUtils.uncapitalize((String)binary.getDisplayName())));
                test.dependsOn(new Object[]{jvmAssembly});
                test.setTestClassesDir(binary.getClassesDir());
                test.setClasspath((FileCollection)binary.getRuntimeClasspath());
                this.configureReports(binary, test);
            }

            private void configureReports(JvmTestSuiteBinarySpecInternal binary2, Test test) {
                TestTaskReports reports = test.getReports();
                File reportsDirectory = new File(buildDir, "reports");
                File reportsOutputDirectory = binary2.getNamingScheme().getOutputDirectory(reportsDirectory);
                File htmlDir = new File(reportsOutputDirectory, "tests");
                File xmlDir = new File(buildDir, "test-results");
                File xmlDirOutputDirectory = binary2.getNamingScheme().getOutputDirectory(xmlDir);
                File binDir = new File(xmlDirOutputDirectory, "binary");
                reports.getHtml().setDestination((Object)htmlDir);
                reports.getJunitXml().setDestination(xmlDirOutputDirectory);
                test.setBinResultsDir(binDir);
            }
        });
    }

    private static String testTaskNameFor(JvmTestSuiteBinarySpec binary) {
        return ((BinarySpecInternal)binary).getProjectScopedName() + "Test";
    }

    @Finalize
    public void configureRuntimeClasspath(@Each JvmTestSuiteBinarySpecInternal testBinary, ServiceRegistry serviceRegistry, ModelSchemaStore modelSchemaStore) {
        ArtifactDependencyResolver dependencyResolver = (ArtifactDependencyResolver)serviceRegistry.get(ArtifactDependencyResolver.class);
        RepositoryHandler repositories = (RepositoryHandler)serviceRegistry.get(RepositoryHandler.class);
        List resolutionAwareRepositories = CollectionUtils.collect((List)repositories, (Transformer)Transformers.cast(ResolutionAwareRepository.class));
        ModelSchema schema = (ModelSchema)Cast.uncheckedCast((Object)modelSchemaStore.getSchema(testBinary.getPublicType()));
        testBinary.setRuntimeClasspath(JvmTestSuiteBasePlugin.configureRuntimeClasspath(testBinary, dependencyResolver, resolutionAwareRepositories, (ModelSchema<? extends JvmTestSuiteBinarySpec>)schema));
    }

    private static DependencyResolvingClasspath configureRuntimeClasspath(JvmTestSuiteBinarySpecInternal testBinary, ArtifactDependencyResolver dependencyResolver, List<ResolutionAwareRepository> resolutionAwareRepositories, ModelSchema<? extends JvmTestSuiteBinarySpec> schema) {
        return new DependencyResolvingClasspath((BinarySpecInternal)testBinary, testBinary.getDisplayName(), dependencyResolver, resolutionAwareRepositories, (ResolveContext)JvmTestSuiteBasePlugin.createResolveContext(testBinary, schema));
    }

    private static LocalComponentResolveContext createResolveContext(JvmTestSuiteBinarySpecInternal testBinary, ModelSchema<? extends JvmTestSuiteBinarySpec> schema) {
        LibraryBinaryIdentifier id = testBinary.getId();
        DefaultLibraryBinaryIdentifier thisId = new DefaultLibraryBinaryIdentifier(id.getProjectPath(), id.getLibraryName() + "Test", id.getVariant());
        return new LocalComponentResolveContext((LibraryBinaryIdentifier)thisId, DefaultVariantsMetaData.extractFrom((BinarySpec)testBinary, schema), JvmTestSuiteBasePlugin.runtimeDependencies(testBinary), UsageKind.RUNTIME, testBinary.getDisplayName());
    }

    private static List<DependencySpec> runtimeDependencies(JvmTestSuiteBinarySpecInternal testBinary) {
        ArrayList dependencies = Lists.newArrayList((Iterable)testBinary.getDependencies());
        JvmBinarySpec testedBinary = testBinary.getTestedBinary();
        dependencies.add(DefaultLibraryBinaryDependencySpec.of((LibraryBinaryIdentifier)testBinary.getId()));
        if (testedBinary != null) {
            JvmBinarySpecInternal binary = (JvmBinarySpecInternal)testedBinary;
            LibraryBinaryIdentifier id = binary.getId();
            dependencies.add(DefaultLibraryBinaryDependencySpec.of((LibraryBinaryIdentifier)id));
        }
        JvmTestSuiteBasePlugin.addSourceSetSpecificDependencies(dependencies, (ModelMap<LanguageSourceSet>)testBinary.getSources());
        JvmTestSuiteBasePlugin.addSourceSetSpecificDependencies(dependencies, (ModelMap<LanguageSourceSet>)testBinary.getTestSuite().getSources());
        return dependencies;
    }

    private static void addSourceSetSpecificDependencies(List<DependencySpec> dependencies, ModelMap<LanguageSourceSet> sources) {
        for (LanguageSourceSet sourceSet : sources) {
            if (!(sourceSet instanceof DependentSourceSet)) continue;
            dependencies.addAll(((DependentSourceSet)sourceSet).getDependencies().getDependencies());
        }
    }
}

