#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: graphviz
version: 2999.18.1.0
id: graphviz-2999.18.1.0-9498a1fded442be02d1ac1c316cc8b3c
key: graph_64yHsYrsikTDDMBq1BsVpC
license: BSD3
copyright: Matthew Sackman, Ivan Lazar Miljenovic
maintainer: Ivan.Miljenovic@gmail.com
stability: Beta
homepage: http://projects.haskell.org/graphviz/
synopsis: Bindings to Graphviz for graph visualisation.
description:
    This library provides bindings for the Dot language used by the
    Graphviz (<http://graphviz.org/>) suite of programs for visualising
    graphs, as well as functions to call those programs.
    .
    Main features of the graphviz library include:
    .
    * Almost complete coverage of all Graphviz attributes and syntax.
    .
    * Support for specifying clusters.
    .
    * The ability to use a custom node type.
    .
    * Functions for running a Graphviz layout tool with all specified
    output types.
    .
    * The ability to not only generate but also parse Dot code with two
    options: strict and liberal (in terms of ordering of statements).
    .
    * Functions to convert FGL graphs and other graph-like data structures
    to Dot code - including support to group them into clusters - with a
    high degree of customisation by specifying which attributes to use
    and limited support for the inverse operation.
    .
    * Round-trip support for passing an FGL graph through Graphviz to
    augment node and edge labels with positional information, etc.
category: Graphs, Graphics
author: Matthew Sackman, Ivan Lazar Miljenovic
exposed: True
exposed-modules:
    Data.GraphViz Data.GraphViz.Types Data.GraphViz.Types.Canonical
    Data.GraphViz.Types.Generalised Data.GraphViz.Types.Graph
    Data.GraphViz.Types.Monadic Data.GraphViz.Parsing
    Data.GraphViz.Printing Data.GraphViz.Commands
    Data.GraphViz.Commands.IO Data.GraphViz.Attributes
    Data.GraphViz.Attributes.Complete Data.GraphViz.Attributes.Colors
    Data.GraphViz.Attributes.Colors.X11
    Data.GraphViz.Attributes.Colors.Brewer
    Data.GraphViz.Attributes.Colors.SVG Data.GraphViz.Attributes.HTML
    Data.GraphViz.PreProcessing Data.GraphViz.Exception
    Data.GraphViz.Algorithms Data.GraphViz.Attributes.Internal
    Data.GraphViz.Internal.Util Data.GraphViz.Internal.State
    Data.GraphViz.Types.Internal.Common
hidden-modules: Data.GraphViz.Algorithms.Clustering
                Data.GraphViz.Attributes.Arrows
                Data.GraphViz.Attributes.ColorScheme Data.GraphViz.Attributes.Same
                Data.GraphViz.Attributes.Values Data.GraphViz.Commands.Available
                Data.GraphViz.Types.State
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/graphviz-2999.18.1.0
library-dirs: /usr/lib/ghc-7.10.3/site-local/graphviz-2999.18.1.0
data-dir: /usr/share/arm-linux-ghc-7.10.3/graphviz-2999.18.1.0
hs-libraries: HSgraphviz-2999.18.1.0-64yHsYrsikTDDMBq1BsVpC
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    colour-2.3.3-991d4439e779e4d0a863b31f2228074a
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    directory-1.2.2.0-17b2023f9d7e8036d19e6b52b4f75c98
    dlist-0.7.1.2-60b8202d1ee1445c0a53e803464ea95b
    fgl-5.5.2.3-e2ac97b21a529f925508ef945c4e2a18
    filepath-1.4.0.0-73e0bec80594160bf6dd6cb25217c6bf
    polyparse-1.12-e6234a5638570dd6df9812cf7a8f00d9
    process-1.2.3.0-21d25f1d78aeea6e68f1c768841f9794
    temporary-1.2.0.4-82bc44ff7d47fd2873d477b044a2a6ac
    text-1.2.2.1-18afbfeccf88d72c4b6e468c86d2b77d
    transformers-0.4.2.0-252429dba576bc247c1932da496e0a3f
    wl-pprint-text-1.1.0.4-7fcdfdbb8076683ee1e51c647eb5fb7b
haddock-interfaces: /usr/share/doc/haskell-graphviz/html/graphviz.haddock
haddock-html: /usr/share/doc/haskell-graphviz/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
