/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.util.Lst;
import javajs.util.SB;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class PickleReader {
    private Viewer vwr;
    private GenericBinaryDocument binaryDoc;
    private Lst<Object> stack = new Lst();
    private Lst<Integer> marks = new Lst();
    private Lst<Object> build = new Lst();
    private Map<Integer, Object> memo = new Hashtable<Integer, Object>();
    private boolean logging;
    private int id;
    private int markCount;
    private int filePt;
    private int emptyListPt;
    private Object thisSection;
    private boolean inMovie;
    private boolean inNames;
    private String thisName;
    private int lastMark;
    private int retrieveCount;
    private static final byte APPEND = 97;
    private static final byte APPENDS = 101;
    private static final byte BINFLOAT = 71;
    private static final byte BININT = 74;
    private static final byte BININT1 = 75;
    private static final byte BININT2 = 77;
    private static final byte BINPUT = 113;
    private static final byte BINSTRING = 84;
    private static final byte BINUNICODE = 87;
    private static final byte BUILD = 98;
    private static final byte EMPTY_DICT = 125;
    private static final byte EMPTY_LIST = 93;
    private static final byte GLOBAL = 99;
    private static final byte LONG_BINPUT = 114;
    private static final byte MARK = 40;
    private static final byte NONE = 78;
    private static final byte OBJ = 111;
    private static final byte SETITEM = 115;
    private static final byte SETITEMS = 117;
    private static final byte SHORT_BINSTRING = 85;
    private static final byte STOP = 46;
    private static final byte BINGET = 104;
    private static final byte LONG_BINGET = 106;
    private static final byte TUPLE = 116;
    private static final byte INT = 73;

    PickleReader(GenericBinaryDocument doc, Viewer vwr) {
        this.binaryDoc = doc;
        this.vwr = vwr;
        this.stack.ensureCapacity(1000);
    }

    private void log(String s) {
        this.vwr.log(s + "\u0000");
    }

    Map<String, Object> getMap(boolean logging) throws Exception {
        Map map;
        String s;
        int i;
        Object o;
        this.logging = logging;
        boolean going = true;
        block29: while (going) {
            byte b = this.binaryDoc.readByte();
            switch (b) {
                case 125: {
                    this.push(new Hashtable());
                    continue block29;
                }
                case 97: {
                    o = this.pop();
                    ((Lst)this.peek()).addLast(o);
                    continue block29;
                }
                case 101: {
                    Lst<Object> l = this.getObjects(this.getMark());
                    if (this.inNames && this.markCount == 2) {
                        int pt = (int)this.binaryDoc.getPosition();
                        System.out.println(" " + this.thisName + " " + this.filePt + " " + (pt - this.filePt));
                        Lst<Integer> l2 = new Lst<Integer>();
                        l2.addLast(this.filePt);
                        l2.addLast(pt - this.filePt);
                        l.addLast(l2);
                    }
                    ((Lst)this.peek()).addAll(l);
                    continue block29;
                }
                case 71: {
                    double d = this.binaryDoc.readDouble();
                    this.push(d);
                    continue block29;
                }
                case 74: {
                    i = this.binaryDoc.readIntLE();
                    this.push(i);
                    continue block29;
                }
                case 75: {
                    i = this.binaryDoc.readByte() & 0xFF;
                    this.push(i);
                    continue block29;
                }
                case 77: {
                    i = (this.binaryDoc.readByte() & 0xFF | (this.binaryDoc.readByte() & 0xFF) << 8) & 0xFFFF;
                    this.push(i);
                    continue block29;
                }
                case 113: {
                    i = this.binaryDoc.readByte();
                    this.putMemo(i, false);
                    continue block29;
                }
                case 114: {
                    i = this.binaryDoc.readIntLE();
                    this.putMemo(i, true);
                    continue block29;
                }
                case 104: {
                    i = this.binaryDoc.readByte();
                    o = this.getMemo(i);
                    this.push(o == null ? "BINGET" + ++this.id : o);
                    continue block29;
                }
                case 106: {
                    i = this.binaryDoc.readIntLE();
                    o = this.getMemo(i);
                    if (o == null) {
                        Logger.error("did not find memo item for " + i);
                        this.push("LONG_BINGET" + ++this.id);
                        continue block29;
                    }
                    this.push(o);
                    continue block29;
                }
                case 85: {
                    i = this.binaryDoc.readByte() & 0xFF;
                    byte[] a = new byte[i];
                    this.binaryDoc.readByteArray(a, 0, i);
                    s = new String(a, "UTF-8");
                    if (this.inNames && this.markCount == 3 && this.lastMark == this.stack.size()) {
                        this.thisName = s;
                        this.filePt = this.emptyListPt;
                    }
                    this.push(s);
                    continue block29;
                }
                case 84: {
                    i = this.binaryDoc.readIntLE();
                    byte[] a = new byte[i];
                    this.binaryDoc.readByteArray(a, 0, i);
                    s = new String(a, "UTF-8");
                    this.push(s);
                    continue block29;
                }
                case 87: {
                    i = this.binaryDoc.readIntLE();
                    byte[] a = new byte[i];
                    this.binaryDoc.readByteArray(a, 0, i);
                    s = new String(a, "UTF-8");
                    this.push(s);
                    continue block29;
                }
                case 93: {
                    this.emptyListPt = (int)this.binaryDoc.getPosition() - 1;
                    this.push(new Lst());
                    continue block29;
                }
                case 99: {
                    Lst<Object> l = new Lst();
                    l.addLast("global");
                    l.addLast(this.readString());
                    l.addLast(this.readString());
                    this.push(l);
                    continue block29;
                }
                case 98: {
                    o = this.pop();
                    this.build.addLast(o);
                    continue block29;
                }
                case 40: {
                    this.putMark(this.stack.size());
                    continue block29;
                }
                case 78: {
                    this.push(null);
                    continue block29;
                }
                case 111: {
                    this.push(this.getObjects(this.getMark()));
                    continue block29;
                }
                case 115: {
                    o = this.pop();
                    if (!(this.peek() instanceof String)) {
                        Logger.error(this.peek() + " is not a string");
                    }
                    s = (String)this.pop();
                    ((Map)this.peek()).put(s, o);
                    continue block29;
                }
                case 117: {
                    int mark = this.getMark();
                    Lst<Object> l = this.getObjects(mark);
                    o = this.peek();
                    if (o instanceof Lst) {
                        for (i = 0; i < l.size(); ++i) {
                            ((Lst)o).addLast(l.get(i));
                        }
                        continue block29;
                    }
                    map = (Map)o;
                    i = l.size();
                    while (--i >= 0) {
                        o = l.get(i);
                        s = (String)l.get(--i);
                        map.put(s, o);
                    }
                    continue block29;
                }
                case 46: {
                    going = false;
                    continue block29;
                }
                case 116: {
                    this.push(this.getObjects(this.getMark()));
                    continue block29;
                }
                case 73: {
                    s = this.readString();
                    try {
                        this.push(Integer.parseInt(s));
                    }
                    catch (Exception e) {
                        long ll = Long.parseLong(s);
                        this.push((int)(ll & 0xFFFFFFFFFFFFFFFFL));
                    }
                    continue block29;
                }
            }
            Logger.error("Pickle reader error: " + b + " " + this.binaryDoc.getPosition());
        }
        if (logging) {
            this.log("");
        }
        Logger.info("PyMOL Pickle reader cached " + this.memo.size() + " tokens; retrieved " + this.retrieveCount);
        this.memo = null;
        map = (Map)this.stack.remove(0);
        if (map.size() == 0) {
            i = this.stack.size();
            while (--i >= 0) {
                o = this.stack.get(i--);
                s = (String)this.stack.get(i);
                map.put(s, o);
            }
        }
        return map;
    }

    private void putMemo(int i, boolean doCheck) {
        Object o = this.peek();
        if (o instanceof String) {
            if (doCheck && this.markCount >= 6 || this.markCount == 3 && this.inMovie) {
                return;
            }
            this.memo.put(i, o);
        }
    }

    private Object getMemo(int i) {
        Object o = this.memo.get(i);
        if (o == null) {
            return o;
        }
        ++this.retrieveCount;
        return o;
    }

    private Lst<Object> getObjects(int mark) {
        int i;
        int n = this.stack.size() - mark;
        Lst<Object> args = new Lst<Object>();
        args.ensureCapacity(n);
        for (i = mark; i < this.stack.size(); ++i) {
            args.addLast(this.stack.get(i));
        }
        i = this.stack.size();
        while (--i >= mark) {
            this.stack.remove(i);
        }
        return args;
    }

    private String readString() throws Exception {
        byte b;
        SB sb = new SB();
        while ((b = this.binaryDoc.readByte()) != 10) {
            sb.appendC((char)b);
        }
        return sb.toString();
    }

    private void putMark(int i) {
        if (this.logging) {
            this.log("\n " + Integer.toHexString((int)this.binaryDoc.getPosition()) + " [");
        }
        this.lastMark = i;
        this.marks.addLast(this.lastMark);
        ++this.markCount;
        switch (this.markCount) {
            case 2: {
                this.thisSection = this.stack.get(i - 2);
                if (!(this.thisSection instanceof String)) break;
                this.inMovie = "movie".equals(this.thisSection);
                this.inNames = "names".equals(this.thisSection);
                break;
            }
        }
    }

    private int getMark() {
        return (Integer)this.marks.remove(--this.markCount);
    }

    private void push(Object o) {
        if (this.logging && (o instanceof String || o instanceof Double || o instanceof Integer)) {
            this.log((o instanceof String ? "'" + o + "'" : o) + ", ");
        }
        this.stack.addLast(o);
    }

    private Object peek() {
        return this.stack.get(this.stack.size() - 1);
    }

    private Object pop() {
        return this.stack.remove(this.stack.size() - 1);
    }
}

