/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.io.AbstractPrimitiveTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.tools.I18n;

public class DownloadPrimitivesTask
extends AbstractPrimitiveTask {
    private final List<PrimitiveId> ids;

    public DownloadPrimitivesTask(OsmDataLayer osmDataLayer, List<PrimitiveId> list, boolean bl) {
        this(osmDataLayer, list, bl, null);
    }

    public DownloadPrimitivesTask(OsmDataLayer osmDataLayer, List<PrimitiveId> list, boolean bl, ProgressMonitor progressMonitor) {
        super(I18n.tr("Download objects", new Object[0]), progressMonitor, osmDataLayer);
        this.ids = list;
        this.setZoom(true);
        this.setDownloadRelations(true, bl);
    }

    @Override
    protected void initMultiFetchReader(MultiFetchServerObjectReader multiFetchServerObjectReader) {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Initializing nodes to download ...", new Object[0]));
        for (PrimitiveId primitiveId : this.ids) {
            OsmPrimitive osmPrimitive = this.layer.data.getPrimitiveById(primitiveId);
            if (osmPrimitive == null) {
                switch (primitiveId.getType()) {
                    case NODE: {
                        osmPrimitive = new Node(primitiveId.getUniqueId());
                        break;
                    }
                    case WAY: {
                        osmPrimitive = new Way(primitiveId.getUniqueId());
                        break;
                    }
                    case RELATION: {
                        osmPrimitive = new Relation(primitiveId.getUniqueId());
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            multiFetchServerObjectReader.append(osmPrimitive);
        }
    }
}

