/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.threading;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private final AtomicInteger count = new AtomicInteger(1);
    private final String name;
    private final int priority;

    public DaemonThreadFactory(String name2) {
        this.name = name2;
        this.priority = 5;
    }

    public DaemonThreadFactory(String name2, int priority2) {
        this.name = name2;
        this.priority = priority2;
    }

    public DaemonThreadFactory() {
        this.name = "JRubyWorker";
        this.priority = 5;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread2 = new Thread(runnable);
        thread2.setName(this.name + "-" + this.count.getAndIncrement());
        thread2.setDaemon(true);
        thread2.setPriority(this.priority);
        return thread2;
    }
}

