/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.StandardFigureSelection;
import CH.ifa.draw.util.Undoable;
import java.util.Vector;

public class UndoableAdapter
implements Undoable {
    private Vector myAffectedFigures;
    private int myAffectedFiguresCount;
    private boolean myIsUndoable;
    private boolean myIsRedoable;
    private DrawingView myDrawingView;

    public UndoableAdapter(DrawingView newDrawingView) {
        this.setDrawingView(newDrawingView);
    }

    public boolean undo() {
        return this.isUndoable();
    }

    public boolean redo() {
        return this.isRedoable();
    }

    public boolean isUndoable() {
        return this.myIsUndoable;
    }

    public void setUndoable(boolean newIsUndoable) {
        this.myIsUndoable = newIsUndoable;
    }

    public boolean isRedoable() {
        return this.myIsRedoable;
    }

    public void setRedoable(boolean newIsRedoable) {
        this.myIsRedoable = newIsRedoable;
    }

    public void setAffectedFigures(FigureEnumeration newAffectedFigures) {
        this.rememberFigures(newAffectedFigures);
    }

    public FigureEnumeration getAffectedFigures() {
        return new FigureEnumerator((Vector)this.myAffectedFigures.clone());
    }

    public int getAffectedFiguresCount() {
        return this.myAffectedFiguresCount;
    }

    protected void rememberFigures(FigureEnumeration toBeRemembered) {
        this.myAffectedFigures = new Vector();
        this.myAffectedFiguresCount = 0;
        while (toBeRemembered.hasMoreElements()) {
            this.myAffectedFigures.addElement(toBeRemembered.nextElement());
            ++this.myAffectedFiguresCount;
        }
    }

    public void release() {
        FigureEnumeration fe = this.getAffectedFigures();
        while (fe.hasMoreElements()) {
            fe.nextFigure().release();
        }
        this.myAffectedFiguresCount = 0;
        this.setAffectedFigures(FigureEnumerator.getEmptyEnumeration());
    }

    protected void duplicateAffectedFigures() {
        this.setAffectedFigures(StandardFigureSelection.duplicateFigures(this.getAffectedFigures(), this.getAffectedFiguresCount()));
    }

    public DrawingView getDrawingView() {
        return this.myDrawingView;
    }

    protected void setDrawingView(DrawingView newDrawingView) {
        this.myDrawingView = newDrawingView;
    }
}

