#ifndef EFL_GENERATED_ELM_APP_SERVER_HH
#define EFL_GENERATED_ELM_APP_SERVER_HH

extern "C"
{
#include <Efl.h>
}
#include <Eo.hh>

#include <eo_cxx_interop.hh>

extern "C"
{
#include "elm_app_server.eo.h"
}

#include "eo_base.eo.hh"
#include <elm_app_server_view.eo.hh>
#include <string>

struct elm_app_server;

/// @cond EO_CXX_ABSTRACT
namespace eo_cxx {

struct elm_app_server
{
   void close_all() const;

   /// @param id 
   ///
   bool view_check(::efl::eina::string_view id_) const;

   /// @param view 
   ///
   void view_add(::elm_app_server_view view_) const;

   /// @param title 
   ///
   void title_set(::efl::eina::optional< ::efl::eina::string_view > title_) const;

   Eina_Stringshare * title_get() const;

   void save() const;

   Eina_Stringshare * icon_get() const;

   void icon_set(Eina_Stringshare * icon_) const;

   Eina_Iterator * views_get() const;

   ::efl::eina::string_view path_get() const;

   Eina_Stringshare * package_get() const;

   void pixels_get(unsigned int* w_, unsigned int* h_, Eina_Bool* has_alpha_, const unsigned char ** pixels_) const;

   void pixels_set(unsigned int w_, unsigned int h_, bool has_alpha_, const unsigned char * pixels_) const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_terminate_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_APP_SERVER_EVENT_TERMINATE, priority_,
            &::efl::eo::_detail::event_callback<::elm_app_server, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_app_server, function_type>,
         ELM_APP_SERVER_EVENT_TERMINATE );
   }

   template <typename T>
   void
   callback_terminate_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_APP_SERVER_EVENT_TERMINATE, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_APP_SERVER_CLASS);
   }

   operator ::elm_app_server() const;
   operator ::elm_app_server&();
   operator ::elm_app_server const&() const;

   /// @cond LOCAL
   template <typename D>
   struct address_of
   {
      operator ::elm_app_server*() const { return static_cast<::elm_app_server*>(static_cast<D const*>(this)->p); }
      operator ::elm_app_server const*() const { return static_cast<::elm_app_server const*>(static_cast<D const*>(this)->p); }
   };

   template <typename D>
   struct address_const_of
   {
      operator ::elm_app_server const*() const { return static_cast<::elm_app_server const*>(static_cast<D const*>(this)->p); }
   };
   /// @endcond

private:

   /// @internal
   Eo* _concrete_eo_ptr() const
   {
      return static_cast<::efl::eo::concrete const*>(static_cast<void const*>(this))->_eo_ptr();
   }

};

}
/// @endcond

/// @brief Class elm_app_server
struct elm_app_server
      : ::efl::eo::concrete
      , EO_CXX_INHERIT(eo::base)
{
   /// @cond LOCAL
   struct _c_constructor
   {

      explicit _c_constructor(::efl::eina::string_view packageid_, Elm_App_Server_Create_View_Cb create_view_cb_)
         : packageid_(packageid_), create_view_cb_(create_view_cb_)
      {}
      void operator()()
      {
         ::elm_app_server_constructor(::efl::eolian::to_c(packageid_), create_view_cb_);
      }
      void register_ev_del_free_callback(Eo* _eoptr)
      {
         (void) _eoptr;
      }

      ::efl::eina::string_view packageid_;
      Elm_App_Server_Create_View_Cb create_view_cb_;
   };
   /// @endcond

   //@{
   /**
      @brief Constructs a new elm_app_server object.

      Constructs a new elm_app_server object. If you want this object to be a child
      of another Eo object, use an @ref efl::eo::parent expression, like the example.

      Since this class have a necessary constructor method, you must call it
      in the right place within this constructor parameters.

      Example:
      @code
      elm_app_server my_elm_app_server(efl::eo::parent = parent_object,
         my_elm_app_server.constructor(packageid_, create_view_cb_));
      @endcode

      @see elm_app_server::constructor
      @see elm_app_server(Eo* eo)
   */
   explicit elm_app_server(::efl::eo::parent_type _p, _c_constructor _c0)
      : elm_app_server(_ctors_call(_p, _c0))
   {}

   explicit elm_app_server(_c_constructor _c0)
      : elm_app_server(_ctors_call(::efl::eo::parent = nullptr, _c0))
   {}
   //@}

   /// @brief Eo Constructor.
   ///
   /// Constructs the object from an Eo* pointer stealing its ownership.
   ///
   /// @param eo The Eo object pointer.
   ///
   explicit elm_app_server(Eo* eo)
      : ::efl::eo::concrete(eo)
   {}

   /// @brief nullptr_t Constructor.
   ///
   /// Constructs an empty (null) object.
   ///
   explicit elm_app_server(std::nullptr_t)
      : ::efl::eo::concrete(nullptr)
   {}

   /// @brief Copy Constructor.
   ///
   elm_app_server(elm_app_server const& other)
      : elm_app_server(eo_ref(other._eo_ptr()))
   {}

   ~elm_app_server() {}

   /// @param packageid 
   /// @param create_view_cb 
   ///
   static _c_constructor constructor(::efl::eina::string_view packageid_, Elm_App_Server_Create_View_Cb create_view_cb_);

   void close_all() const;

   /// @param id 
   ///
   bool view_check(::efl::eina::string_view id_) const;

   /// @param view 
   ///
   void view_add(::elm_app_server_view view_) const;

   /// @param title 
   ///
   void title_set(::efl::eina::optional< ::efl::eina::string_view > title_) const;

   Eina_Stringshare * title_get() const;

   void save() const;

   Eina_Stringshare * icon_get() const;

   void icon_set(Eina_Stringshare * icon_) const;

   Eina_Iterator * views_get() const;

   ::efl::eina::string_view path_get() const;

   Eina_Stringshare * package_get() const;

   void pixels_get(unsigned int* w_, unsigned int* h_, Eina_Bool* has_alpha_, const unsigned char ** pixels_) const;

   void pixels_set(unsigned int w_, unsigned int h_, bool has_alpha_, const unsigned char * pixels_) const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_add_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_ADD, priority_,
            &::efl::eo::_detail::event_callback<::elm_app_server, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_app_server, function_type>,
         EO_BASE_EVENT_CALLBACK_ADD );
   }

   template <typename T>
   void
   callback_callback_add_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_ADD, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_DEL, priority_,
            &::efl::eo::_detail::event_callback<::elm_app_server, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_app_server, function_type>,
         EO_BASE_EVENT_CALLBACK_DEL );
   }

   template <typename T>
   void
   callback_callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_DEL, priority_,
            &::efl::eo::_detail::event_callback<::elm_app_server, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_app_server, function_type>,
         EO_BASE_EVENT_DEL );
   }

   template <typename T>
   void
   callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_terminate_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_APP_SERVER_EVENT_TERMINATE, priority_,
            &::efl::eo::_detail::event_callback<::elm_app_server, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_app_server, function_type>,
         ELM_APP_SERVER_EVENT_TERMINATE );
   }

   template <typename T>
   void
   callback_terminate_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_APP_SERVER_EVENT_TERMINATE, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_APP_SERVER_CLASS);
   }

   /// @cond LOCAL
   struct address_of
      : ::eo_cxx::elm_app_server::address_of<address_of>
      , ::eo_cxx::eo::base::address_of<address_of>
      , ::efl::eo::detail::concrete_address_of
   {
      explicit address_of(::elm_app_server* p)
         : ::efl::eo::detail::concrete_address_of(p)
      {}
   };
   address_of operator&() { return address_of(this); }

   struct address_const_of
      : ::eo_cxx::elm_app_server::address_const_of<address_const_of>
      , ::eo_cxx::eo::base::address_const_of<address_const_of>
      , ::efl::eo::detail::concrete_address_const_of
   {
      explicit address_const_of(::elm_app_server const* p)
         : ::efl::eo::detail::concrete_address_const_of(p)
      {}
   };
   address_const_of operator&() const { return address_const_of(this); }

   /// @endcond

private:

   /// @internal
   static Eo* _ctors_call(::efl::eo::parent_type _p, _c_constructor _c0)
   {
      Eo* _ret_eo = eo_add_ref(ELM_APP_SERVER_CLASS, _p._eo_raw, _c0());

      _c0.register_ev_del_free_callback(_ret_eo);
      return _ret_eo;
   }

   /// @internal
   Eo* _concrete_eo_ptr() const { return _eo_ptr(); }
};

static_assert(sizeof(::elm_app_server) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<::elm_app_server>::value, "");


#include "elm_app_server.eo.impl.hh"

#endif // EFL_GENERATED_ELM_APP_SERVER_HH

