/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.Rule;

public abstract class IteratingRule
extends Rule {
    private MemoryLint context;
    private Pattern classNamePattern;

    public IteratingRule(String string, String string2, String string3) {
        super(string, string2);
        this.setClassNamePattern(string3);
    }

    @Override
    public final void perform() {
        Heap heap = this.context.getHeap();
        List list = heap.getAllClasses();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        for (Object object : list) {
            if (this.classNamePattern.matcher(object.getName()).matches()) {
                arrayList.add(object);
                n += object.getInstancesCount();
            }
            if (!this.context.isInterruped()) continue;
            return;
        }
        BoundedRangeModel boundedRangeModel = this.context.getProgress();
        boundedRangeModel.setMaximum(n != 0 ? n : 1);
        for (JavaClass javaClass : arrayList) {
            List list2 = javaClass.getInstances();
            for (Instance instance : list2) {
                Logger.getLogger(IteratingRule.class.getName()).log(Level.FINE, "Executing rule on {0} instance", instance);
                this.perform(instance);
                boundedRangeModel.setValue(boundedRangeModel.getValue() + 1);
                if (!this.context.isInterruped()) continue;
                return;
            }
        }
        if (n == 0) {
            boundedRangeModel.setValue(1);
        }
        this.summary();
    }

    @Override
    public final void prepare(MemoryLint memoryLint) {
        this.context = memoryLint;
        this.prepareRule(memoryLint);
    }

    protected final void setClassNamePattern(String string) {
        this.classNamePattern = Pattern.compile(string);
    }

    protected abstract void perform(Instance var1);

    protected final MemoryLint getContext() {
        return this.context;
    }

    @Override
    protected JComponent createCustomizer() {
        return null;
    }

    protected void prepareRule(MemoryLint memoryLint) {
    }

    protected void summary() {
    }
}

