/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.ModuleData;
import org.netbeans.ModuleManager;
import org.netbeans.NbInstrumentation;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Union2;

public abstract class Module
extends ModuleInfo {
    public static final String PROP_RELOADABLE = "reloadable";
    public static final String PROP_CLASS_LOADER = "classLoader";
    public static final String PROP_MANIFEST = "manifest";
    public static final String PROP_VALID = "valid";
    public static final String PROP_PROBLEMS = "problems";
    protected final ModuleManager mgr;
    protected final Events events;
    private final Object history;
    private boolean enabled;
    private final boolean autoload;
    protected boolean reloadable;
    private final boolean eager;
    protected ClassLoader classloader;
    private ModuleData data;
    private NbInstrumentation instr;
    private static Method findResources;
    private static final Object DATA_LOCK;

    protected Module(ModuleManager moduleManager, Events events, Object object, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (bl2 && bl3) {
            throw new IllegalArgumentException("A module may not be both autoload and eager");
        }
        this.mgr = moduleManager;
        this.events = events;
        this.history = object;
        this.reloadable = bl;
        this.autoload = bl2;
        this.eager = bl3;
        this.enabled = false;
    }

    protected Module(ModuleManager moduleManager, Events events, Object object, ClassLoader classLoader) throws InvalidException {
        this(moduleManager, events, object, classLoader, false, false);
    }

    protected Module(ModuleManager moduleManager, Events events, Object object, ClassLoader classLoader, boolean bl, boolean bl2) throws InvalidException {
        if (bl && bl2) {
            throw new IllegalArgumentException("A module may not be both autoload and eager");
        }
        this.mgr = moduleManager;
        this.events = events;
        this.history = object;
        this.classloader = classLoader;
        this.reloadable = false;
        this.autoload = bl;
        this.eager = bl2;
        this.enabled = false;
    }

    ModuleData createData(ObjectInput objectInput, Manifest manifest) throws IOException {
        if (objectInput != null) {
            return new ModuleData(objectInput);
        }
        return new ModuleData(manifest, this);
    }

    final void writeData(ObjectOutput objectOutput) throws IOException {
        this.data().write(objectOutput);
    }

    final ModuleData data() {
        try {
            return this.dataWithCheck();
        }
        catch (InvalidException invalidException) {
            throw new IllegalStateException(invalidException);
        }
    }

    final ModuleData dataWithCheck() throws InvalidException {
        Object object = DATA_LOCK;
        synchronized (object) {
            if (this.data != null) {
                return this.data;
            }
            Util.err.log(Level.FINE, "Initialize data {0}", this.getJarFile());
            InputStream inputStream = this.mgr.dataFor(this.getJarFile());
            if (inputStream != null) {
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                    ModuleData moduleData = this.createData(objectInputStream, null);
                    objectInputStream.close();
                    assert (this.data == null);
                    this.data = moduleData;
                    return moduleData;
                }
                catch (IOException iOException) {
                    Util.err.log(Level.INFO, "Cannot read cache for " + this.getJarFile(), iOException);
                }
            }
            try {
                ModuleData moduleData = this.createData(null, this.getManifest());
                assert (moduleData == this.data);
                return moduleData;
            }
            catch (InvalidException invalidException) {
                throw invalidException;
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }

    final void assignData(ModuleData moduleData) {
        assert (Thread.holdsLock(DATA_LOCK));
        this.data = moduleData;
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean bl) {
        if (this.isFixed() && !bl) {
            throw new IllegalStateException("Cannot disable a fixed module: " + (Object)((Object)this));
        }
        this.enabled = bl;
    }

    public boolean isValid() {
        return this.mgr.get(this.getCodeNameBase()) == this;
    }

    public boolean isAutoload() {
        return this.autoload;
    }

    public boolean isEager() {
        return this.eager;
    }

    public Object getAttribute(String string) {
        return this.getManifest().getMainAttributes().getValue(string);
    }

    public String getCodeName() {
        return this.data().getCodeName();
    }

    public String getCodeNameBase() {
        String string = this.mgr.cnbFor(this.getJarFile());
        if (string != null) {
            return string;
        }
        return this.data().getCodeNameBase();
    }

    public int getCodeNameRelease() {
        return this.data().getCodeNameRelease();
    }

    public String[] getProvides() {
        return this.data().getProvides();
    }

    public final boolean provides(String string) {
        String[] stringArray = this.getProvides();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public Set<Dependency> getDependencies() {
        return new HashSet<Dependency>(Arrays.asList(this.getDependenciesArray()));
    }

    public final Dependency[] getDependenciesArray() {
        Dependency[] dependencyArray;
        try {
            dependencyArray = this.data().getDependencies();
        }
        catch (IllegalStateException illegalStateException) {
            dependencyArray = null;
        }
        return dependencyArray == null ? new Dependency[]{} : dependencyArray;
    }

    public SpecificationVersion getSpecificationVersion() {
        return this.data().getSpecificationVersion();
    }

    public String getImplementationVersion() {
        return this.data().getImplementationVersion();
    }

    public String getBuildVersion() {
        return this.data().getBuildVersion();
    }

    public boolean owns(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof Util.ModuleProvider) {
            return ((Util.ModuleProvider)((Object)classLoader)).getModule() == this;
        }
        if (classLoader != this.classloader) {
            return false;
        }
        String string = Module.findClasspathModuleCodeName(clazz);
        if (string != null) {
            return string.equals(this.getCodeName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String findClasspathModuleCodeName(Class<?> clazz) {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            String string;
            URL uRL = codeSource.getLocation();
            if (uRL.toString().matches(".+\\.jar")) {
                uRL = new URL("jar:" + uRL + "!/");
            }
            URL uRL2 = new URL(uRL, "META-INF/MANIFEST.MF");
            InputStream inputStream = uRL2.openStream();
            try {
                string = new Manifest(inputStream).getMainAttributes().getValue("OpenIDE-Module");
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    Logger.getLogger(Module.class.getName()).log(Level.FINE, null, iOException);
                }
            }
            inputStream.close();
            return string;
        }
        return null;
    }

    public PackageExport[] getPublicPackages() {
        return this.data().getPublicPackages();
    }

    boolean isDeclaredAsFriend(Module module) {
        Set<String> set = this.data().getFriendNames();
        if (set == null) {
            return true;
        }
        return set.contains(module.getCodeNameBase());
    }

    protected void parseManifest() throws InvalidException {
        this.data();
    }

    public abstract List<File> getAllJars();

    public boolean isReloadable() {
        return this.reloadable;
    }

    public abstract void setReloadable(boolean var1);

    public abstract void reload() throws IOException;

    public ClassLoader getClassLoader() throws IllegalArgumentException {
        if (!this.enabled) {
            throw new IllegalArgumentException("Not enabled: " + this.getCodeNameBase());
        }
        assert (this.classloader != null) : "Should have had a non-null loader for " + (Object)((Object)this);
        return this.classloader;
    }

    protected abstract void classLoaderUp(Set<Module> var1) throws IOException;

    protected abstract void classLoaderDown();

    protected abstract void cleanup();

    protected abstract void destroy();

    public abstract boolean isFixed();

    public File getJarFile() {
        return null;
    }

    public abstract Manifest getManifest();

    public void releaseManifest() {
    }

    public Set<Object> getProblems() {
        if (!this.isValid()) {
            throw new IllegalStateException("Not valid: " + (Object)((Object)this));
        }
        if (this.isEnabled()) {
            return Collections.emptySet();
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Union2<Dependency, InvalidException> union2 : this.mgr.missingDependencies(this)) {
            if (union2.hasFirst()) {
                hashSet.add(union2.first());
                continue;
            }
            hashSet.add(union2.second());
        }
        return hashSet;
    }

    final void firePropertyChange0(String string, Object object, Object object2) {
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.log(Level.FINE, "Module.propertyChange: {0} {1}: {2} -> {3}", new Object[]{this, string, object, object2});
        }
        this.firePropertyChange(string, object, object2);
    }

    public final Object getHistory() {
        return this.history;
    }

    public final int getStartLevel() {
        return this.getStartLevelImpl();
    }

    int getStartLevelImpl() {
        return -1;
    }

    public String toString() {
        String string = "Module:" + this.getCodeNameBase();
        if (!this.isValid()) {
            string = string + "[invalid]";
        }
        return string;
    }

    public Enumeration<URL> findResources(String string) {
        try {
            if (findResources == null) {
                findResources = ClassLoader.class.getDeclaredMethod("findResources", String.class);
                findResources.setAccessible(true);
            }
            ClassLoader classLoader = this.getClassLoader();
            return (Enumeration)findResources.invoke((Object)classLoader, string);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return Enumerations.empty();
        }
    }

    void refineDependencies(Set<Dependency> set) {
        this.mgr.refineDependencies(this, set);
    }

    void registerCoveredPackages(Set<String> set) {
        this.data().registerCoveredPackages(set);
    }

    Set<String> getCoveredPackages() {
        return this.data().getCoveredPackages();
    }

    public final boolean isNetigso() {
        return this.isNetigsoImpl();
    }

    boolean isNetigsoImpl() {
        return false;
    }

    final void assignInstrumentation(NbInstrumentation nbInstrumentation) {
        this.instr = nbInstrumentation;
    }

    void unregisterInstrumentation() {
        NbInstrumentation.unregisterAgent(this.instr);
    }

    static {
        DATA_LOCK = new Object();
    }

    public static final class PackageExport {
        public final String pkg;
        public final boolean recursive;

        public PackageExport(String string, boolean bl) {
            this.pkg = string;
            this.recursive = bl;
        }

        public String toString() {
            return "PackageExport[" + this.pkg + (this.recursive ? "**/" : "") + "]";
        }

        public boolean equals(Object object) {
            if (!(object instanceof PackageExport)) {
                return false;
            }
            PackageExport packageExport = (PackageExport)object;
            return this.pkg.equals(packageExport.pkg) && this.recursive == packageExport.recursive;
        }

        public int hashCode() {
            return this.pkg.hashCode();
        }

        static void write(DataOutput dataOutput, PackageExport[] packageExportArray) throws IOException {
            if (packageExportArray == null) {
                dataOutput.writeInt(0);
                return;
            }
            dataOutput.writeInt(packageExportArray.length);
            for (PackageExport packageExport : packageExportArray) {
                dataOutput.writeUTF(packageExport.pkg);
                dataOutput.writeBoolean(packageExport.recursive);
            }
        }

        static PackageExport[] read(DataInput dataInput) throws IOException {
            int n = dataInput.readInt();
            if (n == 0) {
                return null;
            }
            PackageExport[] packageExportArray = new PackageExport[n];
            for (int i = 0; i < n; ++i) {
                String string = dataInput.readUTF();
                boolean bl = dataInput.readBoolean();
                packageExportArray[i] = new PackageExport(string, bl);
            }
            return packageExportArray;
        }
    }
}

