/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import org.elasticsearch.action.ActionWriteResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.get.GetResult;

public class UpdateResponse
extends ActionWriteResponse {
    private String index;
    private String id;
    private String type;
    private long version;
    private boolean created;
    private GetResult getResult;

    public UpdateResponse() {
    }

    public UpdateResponse(String index, String type, String id, long version, boolean created) {
        this(new ActionWriteResponse.ShardInfo(0, 0, new ActionWriteResponse.ShardInfo.Failure[0]), index, type, id, version, created);
    }

    public UpdateResponse(ActionWriteResponse.ShardInfo shardInfo, String index, String type, String id, long version, boolean created) {
        this.setShardInfo(shardInfo);
        this.index = index;
        this.id = id;
        this.type = type;
        this.version = version;
        this.created = created;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public void setGetResult(GetResult getResult) {
        this.getResult = getResult;
    }

    public GetResult getGetResult() {
        return this.getResult;
    }

    public boolean isCreated() {
        return this.created;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.type = in.readString();
        this.id = in.readString();
        this.version = in.readLong();
        this.created = in.readBoolean();
        if (in.readBoolean()) {
            this.getResult = GetResult.readGetResult(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeLong(this.version);
        out.writeBoolean(this.created);
        if (this.getResult == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.getResult.writeTo(out);
        }
    }
}

