/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.InternalSingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class SiblingPipelineAggregator
extends PipelineAggregator {
    protected SiblingPipelineAggregator() {
    }

    protected SiblingPipelineAggregator(String name, String[] bucketsPaths, Map<String, Object> metaData) {
        super(name, bucketsPaths, metaData);
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        if (aggregation instanceof InternalMultiBucketAggregation) {
            InternalMultiBucketAggregation multiBucketsAgg = (InternalMultiBucketAggregation)aggregation;
            List<? extends MultiBucketsAggregation.Bucket> buckets = multiBucketsAgg.getBuckets();
            ArrayList<InternalMultiBucketAggregation.InternalBucket> newBuckets = new ArrayList<InternalMultiBucketAggregation.InternalBucket>();
            for (int i = 0; i < buckets.size(); ++i) {
                InternalMultiBucketAggregation.InternalBucket bucket = (InternalMultiBucketAggregation.InternalBucket)buckets.get(i);
                InternalAggregation aggToAdd = this.doReduce(bucket.getAggregations(), reduceContext);
                ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>(CollectionUtils.eagerTransform(bucket.getAggregations().asList(), AGGREGATION_TRANFORM_FUNCTION));
                aggs.add(aggToAdd);
                InternalMultiBucketAggregation.InternalBucket newBucket = multiBucketsAgg.createBucket(new InternalAggregations(aggs), bucket);
                newBuckets.add(newBucket);
            }
            return multiBucketsAgg.create(newBuckets);
        }
        if (aggregation instanceof InternalSingleBucketAggregation) {
            InternalSingleBucketAggregation singleBucketAgg = (InternalSingleBucketAggregation)aggregation;
            InternalAggregation aggToAdd = this.doReduce(singleBucketAgg.getAggregations(), reduceContext);
            ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>(CollectionUtils.eagerTransform(singleBucketAgg.getAggregations().asList(), AGGREGATION_TRANFORM_FUNCTION));
            aggs.add(aggToAdd);
            return singleBucketAgg.create(new InternalAggregations(aggs));
        }
        throw new IllegalStateException("Aggregation [" + aggregation.getName() + "] must be a bucket aggregation [" + aggregation.type().name() + "]");
    }

    public abstract InternalAggregation doReduce(Aggregations var1, InternalAggregation.ReduceContext var2);
}

